/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PCStorage
extends PokemonStorage {
    protected PCBox[] boxes;
    protected List<PCBox> overflowBoxes = new ArrayList<PCBox>();
    protected int lastBox = 0;
    public UUID playerUUID = null;
    public String playerName = null;
    protected transient StoragePosition cachePosition = new StoragePosition(0, 0);

    public PCStorage(UUID uuid, int boxes) {
        super(uuid);
        this.boxes = new PCBox[boxes];
        for (int i = 0; i < boxes; ++i) {
            this.boxes[i] = new PCBox(this, i);
        }
    }

    public PCStorage(UUID uuid) {
        this(uuid, PixelmonConfigProxy.getStorage().getComputerBoxes());
    }

    public void setPlayer(UUID playerUUID, String playerName) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
    }

    public int getLastBox() {
        return this.lastBox;
    }

    public void setLastBox(int lastBox) {
        this.lastBox = lastBox;
    }

    public PCBox[] getBoxes() {
        return (PCBox[])this.boxes.clone();
    }

    public PCBox getBox(int boxNumber) {
        if (boxNumber < 0 || boxNumber >= this.boxes.length) {
            return this.boxes[0];
        }
        return this.boxes[boxNumber];
    }

    public int getBoxCount() {
        return this.boxes.length;
    }

    @Override
    public Pokemon[] getAll() {
        ArrayList<Pokemon> all = new ArrayList<Pokemon>();
        for (PCBox box : this.boxes) {
            all.addAll(Arrays.asList(box.getAll()));
        }
        return all.toArray(new Pokemon[0]);
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        int i;
        if (this.playerName != null) {
            nbt.func_74778_a("player", this.playerName);
        }
        for (i = 0; i < this.boxes.length; ++i) {
            if (this.boxes[i] == null) continue;
            nbt.func_218657_a("BoxNumber" + i, (INBT)this.boxes[i].writeToNBT(new CompoundNBT()));
        }
        if (!this.overflowBoxes.isEmpty()) {
            for (i = 0; i < this.overflowBoxes.size(); ++i) {
                nbt.func_218657_a("BoxNumber" + (i + this.boxes.length), (INBT)this.overflowBoxes.get(i).writeToNBT(new CompoundNBT()));
            }
        }
        nbt.func_74777_a("lastBoxOpen", (short)this.lastBox);
        return nbt;
    }

    @Override
    public PCStorage readFromNBT(CompoundNBT nbt) {
        this.playerName = nbt.func_74779_i("player");
        for (int i = 0; i < this.boxes.length; ++i) {
            this.boxes[i] = nbt.func_74764_b("BoxNumber" + i) ? new PCBox(this, i).readFromNBT(nbt.func_74775_l("BoxNumber" + i)) : (nbt.func_74764_b(String.valueOf(i)) ? new PCBox(this, i).readFromNBT(nbt.func_74775_l(String.valueOf(i))) : new PCBox(this, i));
        }
        if (nbt.func_74764_b("BoxNumber" + this.boxes.length) || nbt.func_74764_b(String.valueOf(this.boxes.length))) {
            boolean originallySavedUpdates = this.shouldSendUpdates;
            this.shouldSendUpdates = false;
            boolean haveFilledMainPC = false;
            PCBox overflowHandleBox = new PCBox(this, this.boxes.length);
            overflowHandleBox.shouldSendUpdates = false;
            int overflowIndex = this.boxes.length;
            while (nbt.func_74764_b("BoxNumber" + overflowIndex) || nbt.func_74764_b(String.valueOf(overflowIndex))) {
                String key = nbt.func_74764_b("BoxNumber" + overflowIndex) ? "BoxNumber" + overflowIndex : String.valueOf(overflowIndex);
                PCBox overflowingBox = new PCBox(this, -1).readFromNBT(nbt.func_74775_l(key));
                overflowingBox.shouldSendUpdates = false;
                int overflowingBoxPokemonIndex = 0;
                int numOverFlown = overflowingBox.countAll();
                while (overflowHandleBox.hasSpace() && numOverFlown > 0) {
                    while (overflowingBoxPokemonIndex < 30) {
                        Pokemon overflowingPokemon = overflowingBox.get(overflowingBoxPokemonIndex);
                        if (overflowingPokemon != null) {
                            if (!haveFilledMainPC) {
                                boolean bl = haveFilledMainPC = !this.add(overflowingPokemon);
                            }
                            if (haveFilledMainPC) {
                                overflowHandleBox.add(overflowingPokemon);
                            }
                            overflowingBox.set(overflowingBoxPokemonIndex, null);
                            ++overflowingBoxPokemonIndex;
                            --numOverFlown;
                            break;
                        }
                        ++overflowingBoxPokemonIndex;
                    }
                    if (overflowHandleBox.hasSpace() || numOverFlown <= 0) continue;
                    this.overflowBoxes.add(overflowHandleBox);
                    overflowHandleBox = new PCBox(this, this.boxes.length + this.overflowBoxes.size());
                    overflowHandleBox.shouldSendUpdates = false;
                }
                ++overflowIndex;
            }
            if (overflowHandleBox.countAll() > 0) {
                this.overflowBoxes.add(overflowHandleBox);
            }
            this.shouldSendUpdates = originallySavedUpdates;
        }
        this.lastBox = nbt.func_74765_d("lastBoxOpen");
        if (this.lastBox >= this.boxes.length || this.lastBox < 0) {
            this.lastBox = this.boxes.length - 1;
        }
        return this;
    }

    @Override
    public StoragePosition getFirstEmptyPosition() {
        PCBox box = this.boxes[this.lastBox];
        if (box != null && box.hasSpace()) {
            return new StoragePosition(this.lastBox, box.getFirstEmptyPosition().order);
        }
        for (int i = 0; i < this.boxes.length; ++i) {
            if (i == this.lastBox || !this.boxes[i].hasSpace()) continue;
            return new StoragePosition(i, this.boxes[i].getFirstEmptyPosition().order);
        }
        return null;
    }

    @Override
    public void set(StoragePosition position, Pokemon pokemon) {
        this.boxes[position.box].set(position, pokemon);
        this.setNeedsSaving();
        if (this.getShouldSendUpdates() && this.playerUUID != null) {
            PokedexEvent.Pre preEvent;
            PlayerPartyStorage partyStorage = StorageProxy.getParty(this.playerUUID);
            if (pokemon != null && !pokemon.isEgg() && partyStorage.playerPokedex.getSeenMap().get(pokemon.getSpecies().getDex()) != PokedexRegistrationStatus.CAUGHT && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(this.uuid, pokemon, PokedexRegistrationStatus.CAUGHT, "storageMovement")))) {
                partyStorage.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                partyStorage.playerPokedex.update();
                partyStorage.setNeedsSaving();
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(this.uuid, preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
        }
    }

    public void set(int box, int slot, Pokemon pokemon) {
        this.set(new StoragePosition(box, slot), pokemon);
    }

    @Override
    @Nullable
    public Pokemon get(StoragePosition position) {
        return this.boxes[position.box].pokemon[position.order];
    }

    @Nullable
    public Pokemon get(int box, int slot) {
        return this.get(this.cachePosition.set(box, slot));
    }

    @Override
    public void swap(StoragePosition position1, StoragePosition position2) {
        if (position1.box == position2.box) {
            this.boxes[position1.box].swap(position1, position2);
        } else {
            Pokemon temp = this.boxes[position1.box].get(position1);
            this.boxes[position1.box].pokemon[position1.order] = this.boxes[position2.box].get(position2);
            this.boxes[position2.box].pokemon[position2.order] = temp;
            Pokemon pokemon1 = this.get(position1);
            Pokemon pokemon2 = this.get(position2);
            if (pokemon1 != null) {
                pokemon1.setStorage(this, position1);
            }
            if (pokemon2 != null) {
                pokemon2.setStorage(this, position2);
            }
            this.notifyListeners(position1, pokemon1, new EnumUpdateType[0]);
            this.notifyListeners(position2, pokemon2, new EnumUpdateType[0]);
        }
        this.setNeedsSaving();
    }

    public void swap(int box1, int slot1, int box2, int slot2) {
        this.swap(new StoragePosition(box1, slot1), new StoragePosition(box2, slot2));
    }

    @Override
    public StoragePosition getPosition(Pokemon pokemon) {
        for (PCBox box : this.boxes) {
            StoragePosition position;
            if (box == null || (position = box.getPosition(pokemon)) == null) continue;
            return position;
        }
        return null;
    }

    @Override
    public List<ServerPlayerEntity> getPlayersToUpdate() {
        ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.uuid);
        return player == null ? new ArrayList() : Collections.singletonList(player);
    }

    @Override
    public File getFile() {
        return new File(ServerLifecycleHooks.getCurrentServer().func_71218_a((RegistryKey)World.field_234918_g_).func_217481_x().field_215759_d, "pokemon/" + this.uuid.toString() + ".comp");
    }

    @Override
    public boolean getShouldSave() {
        if (this.hasChanged) {
            return true;
        }
        for (PCBox box : this.boxes) {
            if (!box.hasChanged) continue;
            return true;
        }
        return this.playerUUID != null && ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().func_184103_al() != null && ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.playerUUID) == null;
    }

    @Override
    public void setHasChanged(boolean hasChanged) {
        super.setHasChanged(hasChanged);
        if (!hasChanged) {
            for (PCBox box : this.boxes) {
                box.setHasChanged(false);
            }
        }
    }

    public void sendContents(ServerPlayerEntity player) {
        for (PCBox box : this.boxes) {
            if (box == null) continue;
            box.sendContents(player);
        }
    }
}

