/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.LevelRequirement;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnInfoNPCTrainer;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerData;
import java.util.ArrayList;
import java.util.function.Function;

public class SpawnActionNPCTrainer
extends SpawnAction<NPCTrainer> {
    public String trainerType = "Youngster";

    public SpawnActionNPCTrainer(SpawnInfoNPCTrainer spawnInfo, SpawnLocation spawnLocation) {
        super(spawnInfo, spawnLocation);
        this.trainerType = spawnInfo.trainerType;
    }

    @Override
    protected NPCTrainer createEntity() {
        if (PixelmonConfigProxy.getSpawning().allGenerationsDisabled()) {
            return null;
        }
        BaseTrainer baseTrainer = ServerNPCRegistry.trainers.get(this.trainerType);
        if (baseTrainer == null) {
            baseTrainer = ServerNPCRegistry.trainers.getRandomBaseWithData();
        }
        NPCTrainer entity = new NPCTrainer(this.spawnLocation.location.world);
        entity.init(baseTrainer);
        SpawnInfoNPCTrainer spawnInfo = (SpawnInfoNPCTrainer)this.spawnInfo;
        if (spawnInfo.winMoney != -1) {
            entity.winMoney = spawnInfo.winMoney;
        }
        int level = RandomHelper.getRandomNumberBetween(spawnInfo.getMinLevel(), spawnInfo.getMaxLevel());
        entity.setPokemonLevel(level);
        for (int i = 0; i < 6; ++i) {
            entity.getPokemonStorage().set(i, null);
        }
        if (spawnInfo.name != null) {
            entity.setName(spawnInfo.name);
            entity.usingDefaultName = false;
        }
        Function<PokemonSpecification, Pokemon> createPoke = spec -> {
            Pokemon pokemon = spec.create();
            Integer specLevel = spec.getValue(LevelRequirement.class).orElse(null);
            if (specLevel == null) {
                pokemon.getPokemonLevelContainer().setLevel(level);
            }
            return pokemon;
        };
        int pokemonCount = 0;
        if (spawnInfo.guaranteedPokemon != null && !spawnInfo.guaranteedPokemon.isEmpty()) {
            for (PokemonSpecification pokemonSpecification : spawnInfo.guaranteedPokemon) {
                Pokemon pokemon = createPoke.apply(pokemonSpecification);
                if (!PixelmonConfigProxy.getSpawning().isGenerationEnabled(pokemon.getSpecies().getGeneration())) {
                    return null;
                }
                ++pokemonCount;
                entity.getPokemonStorage().add(pokemon);
            }
        }
        ArrayList<PokemonSpecification> filteredPossiblePokemon = null;
        if (PixelmonConfigProxy.getSpawning().allGenerationsEnabled()) {
            filteredPossiblePokemon = spawnInfo.possiblePokemon;
        } else if (spawnInfo.possiblePokemon != null) {
            for (PokemonSpecification spec3 : spawnInfo.possiblePokemon) {
                if (filteredPossiblePokemon == null) {
                    filteredPossiblePokemon = new ArrayList();
                }
                filteredPossiblePokemon.add(spec3);
            }
        }
        int n = RandomHelper.getRandomNumberBetween(spawnInfo.getMinPartySize(), spawnInfo.getMaxPartySize());
        while (n > pokemonCount && filteredPossiblePokemon != null && !filteredPossiblePokemon.isEmpty()) {
            PokemonSpecification randomSpec = CollectionHelper.getRandomElement(filteredPossiblePokemon);
            Pokemon pokemon = createPoke.apply(randomSpec);
            entity.getPokemonStorage().add(pokemon);
            ++pokemonCount;
        }
        if (entity.getPokemonStorage().countPokemon() == 0) {
            TrainerData data = ServerNPCRegistry.trainers.getRandomData(this.trainerType);
            if (data != null) {
                ArrayList<Pokemon> randomParty = data.getRandomParty();
                if (randomParty != null && !randomParty.isEmpty()) {
                    entity.loadPokemon(randomParty);
                }
            } else if (PixelmonConfigProxy.getSpawning().allGenerationsEnabled()) {
                entity.getPokemonStorage().add(PokemonSpecificationProxy.create("random", "lvl:" + spawnInfo.getMinLevel()).create());
            } else {
                entity.getPokemonStorage().add(PokemonSpecificationProxy.create("random", "lvl:" + spawnInfo.getMinLevel(), "generation:" + PixelmonConfigProxy.getSpawning().getRandomEnabledGeneration()).create());
            }
            block4: while (entity.getPokemonStorage().countPokemon() > spawnInfo.getMaxPartySize()) {
                for (int i = 5; i >= 0; --i) {
                    if (entity.getPokemonStorage().get(i) == null) continue;
                    entity.getPokemonStorage().set(i, null);
                    continue block4;
                }
            }
        }
        if (entity.getPokemonStorage().countPokemon() == 0) {
            return null;
        }
        if (spawnInfo.greeting != null) {
            entity.usingDefaultGreeting = false;
            entity.greeting = spawnInfo.greeting;
        }
        if (spawnInfo.winMessage != null) {
            entity.winMessage = spawnInfo.winMessage;
            entity.usingDefaultWin = false;
        }
        if (spawnInfo.loseMessage != null) {
            entity.loseMessage = spawnInfo.loseMessage;
            entity.usingDefaultLose = false;
        }
        if (spawnInfo.bossTier != null) {
            entity.setBossTier(BossTierRegistry.getBossTierOrNotBoss(spawnInfo.bossTier));
        }
        return entity;
    }
}

