/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.links;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUpPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class DelegateLink
extends PokemonLink {
    public Pokemon pokemon;

    public DelegateLink(Pokemon pokemon) {
        this.pokemon = pokemon;
    }

    @Override
    public Pokemon getPokemon() {
        return this.pokemon;
    }

    @Override
    public PermanentStats getStats() {
        return this.pokemon.getStats();
    }

    @Override
    public HeldItem getHeldItem() {
        return this.pokemon.getHeldItemAsItemHeld();
    }

    @Override
    public void setHeldItem(ItemStack item) {
        this.pokemon.setHeldItem(item);
    }

    @Override
    public int getHealth() {
        return this.pokemon.getHealth();
    }

    @Override
    public int getMaxHealth() {
        return this.getMaxHealth(false);
    }

    @Override
    public int getMaxHealth(boolean ignoreDynamax) {
        return this.pokemon.getMaxHealth();
    }

    @Override
    public void setHealth(int health) {
        this.pokemon.setHealth(health);
    }

    @Override
    public int getPokemonLevel() {
        return this.pokemon.getPokemonLevel();
    }

    @Override
    public void setLevel(int level) {
        this.pokemon.setLevelNum(level);
    }

    @Override
    public int getExp() {
        return this.pokemon.getExperience();
    }

    @Override
    public void setExp(int experience) {
        this.pokemon.setExperience(experience);
    }

    @Override
    public int getFriendship() {
        return this.pokemon.getFriendship();
    }

    @Override
    public boolean doesLevel() {
        return this.pokemon.doesLevel();
    }

    @Override
    public ServerPlayerEntity getPlayerOwner() {
        return this.pokemon.getOwnerPlayer();
    }

    @Override
    public BattleController getBattleController() {
        PixelmonWrapper pw = this.pokemon.getPixelmonWrapper().orElse(null);
        return pw == null ? null : pw.bc;
    }

    @Override
    public Moveset getMoveset() {
        return this.pokemon.getMoveset();
    }

    @Override
    public UUID getPokemonUUID() {
        return this.pokemon.getUUID();
    }

    @Override
    public PixelmonEntity getEntity() {
        return this.pokemon.getOrSpawnPixelmon((Entity)(this.getPlayerOwner() == null ? null : this.getPlayerOwner()));
    }

    @Override
    public void setScale(float scale) {
        this.pokemon.ifEntityExists(pixelmon -> pixelmon.setPixelmonScale(scale));
    }

    @Override
    public World getWorld() {
        PixelmonEntity pixelmon = this.pokemon.getPixelmonEntity().orElse(null);
        return pixelmon == null ? null : pixelmon.func_130014_f_();
    }

    @Override
    public Gender getGender() {
        return this.pokemon.getGender();
    }

    @Override
    public BlockPos getPos() {
        PixelmonEntity pixelmon = this.pokemon.getPixelmonEntity().orElse(null);
        return pixelmon == null ? null : pixelmon.func_233580_cy_();
    }

    @Override
    public PartyStorage getStorage() {
        return (PartyStorage)this.pokemon.getStorageAndPosition().func_76341_a();
    }

    @Override
    public void update(EnumUpdateType ... updateTypes) {
        this.pokemon.markDirty(updateTypes);
    }

    @Override
    public void updateStats() {
        this.pokemon.getStats().setLevelStats(this.getNature(), this.getBaseStats(), this.getPokemonLevel());
        this.update(Pokemon.STATS);
    }

    @Override
    public void updateLevelUp(PixelmonStatsData stats) {
        ServerPlayerEntity owner = this.pokemon.getOwnerPlayer();
        if (owner != null) {
            PixelmonStatsData stats2 = PixelmonStatsData.createPacket(this);
            NetworkHelper.sendPacket(new LevelUpPacket(this.getPokemonUUID(), this.getPokemonLevel(), stats, stats2, new PixelmonClientData(this.pokemon)), owner);
            this.pokemon.markDirty(EnumUpdateType.Stats);
        }
    }

    @Override
    public void sendMessage(String langKey, Object ... data) {
        ServerPlayerEntity player = this.pokemon.getOwnerPlayer();
        if (player != null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(langKey, data), Util.field_240973_b_);
        }
    }

    @Override
    public ITextComponent getNickname() {
        return this.pokemon.getFormattedDisplayName();
    }

    @Override
    public String getOriginalTrainer() {
        return this.pokemon.getOriginalTrainer();
    }

    @Override
    public boolean removeStatuses(StatusType ... statuses) {
        for (StatusType statusType : statuses) {
            if (!statusType.isPrimaryStatus() || !this.pokemon.getStatus().isStatus(statusType)) continue;
            this.pokemon.setStatus(NoStatus.noStatus);
            return true;
        }
        return false;
    }

    @Override
    public Nature getNature() {
        return this.pokemon.getNature();
    }

    @Override
    public int getExpToNextLevel() {
        return this.pokemon.getExperienceToLevelUp();
    }

    @Override
    public StatusPersist getPrimaryStatus() {
        return this.pokemon.getStatus();
    }

    @Override
    public Ability getAbility() {
        return this.pokemon.getAbility();
    }

    @Override
    public List<Element> getType() {
        return this.getBaseStats().getTypes();
    }

    @Override
    public String getForm() {
        return this.pokemon.getForm().getName();
    }

    @Override
    public boolean isEgg() {
        return this.pokemon.isEgg();
    }

    @Override
    public int getEggCycles() {
        return this.pokemon.getEggCycles();
    }

    @Override
    public int getPartyPosition() {
        return ((StoragePosition)this.pokemon.getStorageAndPosition().func_76340_b()).order;
    }

    @Override
    public boolean hasOwner() {
        return this.pokemon.getStorageAndPosition().func_76341_a() != null;
    }

    @Override
    public Optional<Pokerus> getPokerus() {
        return Optional.ofNullable(this.pokemon.getPokerus());
    }

    @Override
    public void adjustFriendship(int change) {
        if (change > 0) {
            this.pokemon.increaseFriendship(change);
        } else {
            this.pokemon.decreaseFriendship(-change);
        }
    }
}

