/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class GenderCondition
extends EvoCondition {
    public ArrayList<Gender> genders;

    public GenderCondition(Gender ... genders) {
        super("gender");
        this.genders = Lists.newArrayList((Object[])genders);
    }

    @Override
    public boolean passes(PixelmonEntity pixelmon) {
        return this.genders.contains(pixelmon.getPokemon().getGender());
    }

    @Override
    public IFormattableTextComponent getDescription() {
        return PixelmonCommandUtils.format("pixelmon.evolution.conditions.gender", TextHelper.join(this.genders.stream().map(ITranslatable::getTranslatedName).collect(Collectors.toList()), (ITextComponent)TextHelper.OR_DELIMITER));
    }
}

