/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.species.DataCopier;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class GenderPropertiesTypeAdapter
implements JsonSerializer<GenderProperties>,
JsonDeserializer<GenderProperties> {
    public GenderProperties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        DataCopier.resetPalette();
        String genderString = object.get("gender").getAsString();
        Gender gender = genderString.equalsIgnoreCase("ALL") ? Gender.NONE : Gender.valueOf(genderString);
        ArrayList palettes = Lists.newArrayList();
        for (JsonElement property : object.get("palettes").getAsJsonArray()) {
            PaletteProperties properties = (PaletteProperties)context.deserialize((JsonElement)property.getAsJsonObject(), PaletteProperties.class);
            palettes.add(properties);
        }
        return new GenderProperties(gender, palettes.toArray(new PaletteProperties[0]));
    }

    public JsonElement serialize(GenderProperties src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        JsonArray palettes = new JsonArray();
        for (PaletteProperties palette : src.getPalettes()) {
            palettes.add(context.serialize((Object)palette));
        }
        object.addProperty("gender", src.getGender().name());
        object.add("palettes", (JsonElement)palettes);
        return object;
    }
}

