/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.abilities.Abilities;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class AbilitiesTypeAdapter
implements JsonSerializer<Abilities>,
JsonDeserializer<Abilities> {
    public Abilities deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Ability foundAbility;
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList abilities = Lists.newArrayList();
        ArrayList hiddenAbilities = Lists.newArrayList();
        for (JsonElement ability : jsonObject.getAsJsonArray("abilities")) {
            foundAbility = AbilityRegistry.getAbility(ability.getAsString()).orElse(null);
            if (foundAbility == null) {
                Pixelmon.LOGGER.error("Cannot find ability with name '" + ability.getAsString() + "'!");
                continue;
            }
            abilities.add(foundAbility);
        }
        if (jsonObject.has("hiddenAbilities")) {
            for (JsonElement hiddenAbility : jsonObject.getAsJsonArray("hiddenAbilities")) {
                foundAbility = AbilityRegistry.getAbility(hiddenAbility.getAsString()).orElse(null);
                if (foundAbility == null) {
                    Pixelmon.LOGGER.error("Cannot find ability with name '" + hiddenAbility.getAsString() + "'!");
                    continue;
                }
                hiddenAbilities.add(foundAbility);
            }
        }
        if (abilities.size() == 0) {
            throw new RuntimeException("Invalid data pack. There is a form with 0 abilities");
        }
        return new Abilities(abilities.toArray(new Ability[0]), hiddenAbilities.toArray(new Ability[0]));
    }

    public JsonElement serialize(Abilities src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        JsonArray abilities = new JsonArray();
        for (Ability ability : src.getAbilities()) {
            abilities.add(ability.getName());
        }
        jsonObject.add("abilities", (JsonElement)abilities);
        JsonArray hiddenAbilities = new JsonArray();
        for (Ability hiddenAbility : src.getHiddenAbilities()) {
            hiddenAbilities.add(hiddenAbility.getName());
        }
        jsonObject.add("hiddenAbilities", (JsonElement)hiddenAbilities);
        return jsonObject;
    }
}

