/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.parameters.flying;

import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.flying.LandingMaterials;
import java.util.Objects;

public class FlyingParameters {
    private final int flyHeightMin;
    private final int flyHeightMax;
    private final float flySpeedModifier;
    private final int flyRefreshRateY;
    private final int flyRefreshRateXZ;
    private final int flyRefreshRateSpeed;
    private final int flightTimeMin;
    private final int flightTimeMax;
    private final int flapRate;
    private final LandingMaterials landingMaterials;

    public FlyingParameters(int heightMin, int heightMax, float speedMod, int rateY, int rateXZ, int rateSpeed, int flightTimeMin, int flightTimeMax, int flapRate, LandingMaterials landingMaterials) {
        this.flyHeightMin = heightMin;
        this.flyHeightMax = heightMax;
        this.flySpeedModifier = speedMod;
        this.flyRefreshRateY = rateY;
        this.flyRefreshRateXZ = rateXZ;
        this.flyRefreshRateSpeed = rateSpeed;
        this.flightTimeMin = flightTimeMin;
        this.flightTimeMax = flightTimeMax;
        this.flapRate = flapRate / 4;
        this.landingMaterials = landingMaterials;
    }

    public FlyingParameters() {
        this(0, 10, 1.0f, 100, 100, 100, 0, 20, 20, LandingMaterials.NONE);
    }

    public int getFlyHeightMin() {
        return this.flyHeightMin;
    }

    public int getFlyHeightMax() {
        return this.flyHeightMax;
    }

    public float getFlySpeedModifier() {
        return this.flySpeedModifier;
    }

    public int getFlyRefreshRateY() {
        return this.flyRefreshRateY;
    }

    public int getFlyRefreshRateXZ() {
        return this.flyRefreshRateXZ;
    }

    public int getFlyRefreshRateSpeed() {
        return this.flyRefreshRateSpeed;
    }

    public int getFlightTimeMin() {
        return this.flightTimeMin;
    }

    public int getFlightTimeMax() {
        return this.flightTimeMax;
    }

    public int getFlapRate() {
        return this.flapRate;
    }

    public LandingMaterials getLandingMaterials() {
        return this.landingMaterials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlyingParameters)) {
            return false;
        }
        FlyingParameters that = (FlyingParameters)o;
        return this.getFlyHeightMin() == that.getFlyHeightMin() && this.getFlyHeightMax() == that.getFlyHeightMax() && Float.compare(that.getFlySpeedModifier(), this.getFlySpeedModifier()) == 0 && this.getFlyRefreshRateY() == that.getFlyRefreshRateY() && this.getFlyRefreshRateXZ() == that.getFlyRefreshRateXZ() && this.getFlyRefreshRateSpeed() == that.getFlyRefreshRateSpeed() && this.getFlightTimeMin() == that.getFlightTimeMin() && this.getFlightTimeMax() == that.getFlightTimeMax() && this.getFlapRate() == that.getFlapRate() && this.getLandingMaterials() == that.getLandingMaterials();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getFlyHeightMin(), this.getFlyHeightMax(), Float.valueOf(this.getFlySpeedModifier()), this.getFlyRefreshRateY(), this.getFlyRefreshRateXZ(), this.getFlyRefreshRateSpeed(), this.getFlightTimeMin(), this.getFlightTimeMax(), this.getFlapRate(), this.getLandingMaterials()});
    }
}

