/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ribbon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.RibbonTypeReader;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.impl.DeveloperRibbonTypeReader;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.impl.SimpleRibbonTypeReader;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RibbonTypeRegistry {
    private static final Map<String, RibbonTypeReader> REGISTERED_DESERLIAZERS = Maps.newHashMap();

    private RibbonTypeRegistry() {
        throw new UnsupportedOperationException("Static registry class");
    }

    public static void register(RibbonTypeReader reader) {
        REGISTERED_DESERLIAZERS.put(reader.id().toLowerCase(Locale.ROOT), reader);
    }

    public static RibbonTypeReader get(String id) {
        return REGISTERED_DESERLIAZERS.get(id.toLowerCase(Locale.ROOT));
    }

    public static void unregister(String id) {
        REGISTERED_DESERLIAZERS.remove(id.toLowerCase(Locale.ROOT));
    }

    public static List<RibbonTypeReader> getRegisteredReaders() {
        return Lists.newArrayList(REGISTERED_DESERLIAZERS.values());
    }

    public static void bootstrap() {
        RibbonTypeRegistry.register(new SimpleRibbonTypeReader());
        RibbonTypeRegistry.register(new DeveloperRibbonTypeReader());
    }
}

