/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.catching;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureHealth;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureValues;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.eventbus.api.Event;

public interface CaptureMethod {
    public static final List<StatusType> MAJOR_STATUSES = Lists.newArrayList((Object[])new StatusType[]{StatusType.Freeze, StatusType.Sleep});
    public static final List<StatusType> MINOR_STATUSES = Lists.newArrayList((Object[])new StatusType[]{StatusType.Paralysis, StatusType.Poison, StatusType.PoisonBadly, StatusType.Burn});

    default public CaptureValues calculateCapture(CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, @Nullable RaidData raid, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        CaptureValues values = this.constructValues(pokeBall, pokeBallEntity, thrower, pokemon, mode);
        if (raid == null ? this.preCaptureChecks(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode) : this.preRaidCaptureChecks(values, health, pokeBall, pokeBallEntity, raid, thrower, pokemon, mode)) {
            return this.tryCapture(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
        }
        return values;
    }

    default public int calculateCatchRate(PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        return pokeBall.getLogic().modifyCaptureRate(pokeBall, pokeBallEntity, pokemon, pokemon.getForm().getCatchRate());
    }

    default public double calculateBallBonus(PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        return pokeBall.getLogic().getCatchBonus(pokeBall, pokeBallEntity, (PlayerEntity)thrower, pokemon, mode);
    }

    default public CaptureValues constructValues(PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        return new CaptureValues(this.calculateCatchRate(pokeBall, pokeBallEntity, thrower, pokemon, mode), this.calculateBallBonus(pokeBall, pokeBallEntity, thrower, pokemon, mode));
    }

    default public boolean preCaptureChecks(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        return !Pixelmon.EVENT_BUS.post((Event)new CaptureEvent.StartCapture(thrower, health.getEntity(), pokeBallEntity, values)) && !health.getEntity().getBossTier().isBoss() && health.getEntity().getOwner() == null && health.getEntity().getPokemon().getPokemonLevel() <= PixelmonServerConfig.maxLevel && !health.getEntity().isUncatchable();
    }

    default public boolean preRaidCaptureChecks(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, RaidData raid, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        return !Pixelmon.EVENT_BUS.post((Event)new CaptureEvent.StartRaidCapture(thrower, pokemon, raid, values)) && !health.getRaidPlayer().possibleCatch.isUncatchable();
    }

    default public double statusEffectCheck(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        if (health.hasWrapper()) {
            StatusType currentStatus;
            PixelmonWrapper pw = health.getWrapper();
            StatusType statusType = currentStatus = pw == null ? pokemon.getStatus().type : pw.getPrimaryStatus().type;
            if (MAJOR_STATUSES.contains(currentStatus)) {
                return 2.5;
            }
            if (MINOR_STATUSES.contains(currentStatus)) {
                return 1.5;
            }
        }
        return 1.0;
    }

    default public void criticalCaptureCheck(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        PlayerPartyStorage pps = StorageProxy.getParty(thrower);
        double a = values.getVariable("A");
        int caught = pps.playerPokedex.countCaught();
        double am = caught <= 30 ? 0.0 : (caught <= 150 ? a * 0.5 : (caught <= 300 ? a : (caught <= 450 ? a * 1.5 : (caught <= 600 ? a * 2.0 : a * 2.5))));
        if (pps.getCatchingCharm().isActive()) {
            am *= PixelmonConfigProxy.getGeneral().getCatchingCharmMultiplier();
        }
        int c = (int)Math.floor(am / 6.0);
        if (RandomHelper.getRandom().nextInt(256) < c) {
            values.setCritical();
        }
    }

    default public void captureCalculation(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        double hpMax = health.getMaxHP();
        double hpCurrent = health.getCurrentHP();
        PixelmonWrapper pw = health.getWrapper();
        if (pw != null) {
            hpCurrent = pw.getHealth();
        }
        double bonusStatus = this.statusEffectCheck(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
        double a = (3.0 * hpMax - 2.0 * hpCurrent) * (double)values.getCatchRate() * values.getBallBonus() / (3.0 * hpMax) * bonusStatus;
        double b = (double)Math.round(Math.pow(255.0 / a, 0.25) * 4096.0) / 4096.0;
        b = Math.floor(65536.0 / b);
        values.setVariable("A", a);
        values.setVariable("B", b);
    }

    default public void shakeCountCheck(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        double a = values.getVariable("A");
        double b = values.getVariable("B");
        if (values.getCatchRate() > 0 && b != 0.0) {
            if (a < 255.0) {
                for (int i = 0; i < 4; ++i) {
                    int roll = RandomHelper.getRandom().nextInt(65536);
                    if (!((double)roll <= b)) continue;
                    values.addShake();
                    if (!values.isCritical()) continue;
                    values.setCaught(1);
                    return;
                }
            } else {
                values.setShakes(4);
            }
        }
        values.trySetCaught(4);
    }

    public CaptureValues tryCapture(CaptureValues var1, CaptureHealth var2, PokeBall var3, @Nullable PokeBallEntity var4, ServerPlayerEntity var5, Pokemon var6, PokeBallMode var7);
}

