/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Hail;
import com.pixelmonmod.pixelmon.battles.status.Weather;

public class IceFace
extends AbstractAbility {
    @Override
    public int modifyDamageIncludeFixed(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (!target.getSpecies().is(PixelmonSpecies.EISCUE)) {
            return damage;
        }
        if (target.getForm().isForm("ice_face") && a.getAttackCategory() == AttackCategory.PHYSICAL) {
            if (!target.bc.simulateMode) {
                target.bc.sendToAll("pixelmon.abilities.iceface.protected", target.getNickname());
                target.setForm("noice_face");
            }
            return 0;
        }
        return damage;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (!newPokemon.getSpecies().is(PixelmonSpecies.EISCUE) || newPokemon.bc.simulateMode) {
            return;
        }
        if (newPokemon.bc.globalStatusController.getWeather() instanceof Hail) {
            this.repair(newPokemon);
        }
    }

    @Override
    public void onWeatherChange(PixelmonWrapper pw, Weather weather) {
        if (!pw.getSpecies().is(PixelmonSpecies.EISCUE) || pw.bc.simulateMode) {
            return;
        }
        if (weather instanceof Hail) {
            this.repair(pw);
        }
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }

    private void repair(PixelmonWrapper pw) {
        if (pw.getForm().isForm("noice_face")) {
            pw.bc.sendToAll("pixelmon.abilities.iceface.restore", pw.getNickname());
            pw.setForm("ice_face");
        }
    }
}

