/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;

public class FlowerGift
extends AbstractAbility {
    @Override
    public int[] modifyStatsTeammate(PixelmonWrapper pokemon, int[] stats) {
        if (pokemon.bc.globalStatusController.hasStatus(StatusType.Sunny)) {
            int n = BattleStatsType.ATTACK.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    public int[] modifyStatsCancellableTeammate(PixelmonWrapper pokemon, int[] stats) {
        if (pokemon.bc.globalStatusController.hasStatus(StatusType.Sunny)) {
            int n = BattleStatsType.SPECIAL_DEFENSE.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    public void onWeatherChange(PixelmonWrapper pw, Weather weather) {
        StatusType weatherType;
        if (!pw.getSpecies().is(PixelmonSpecies.CHERRIM) || pw.bc.simulateMode) {
            return;
        }
        StatusType statusType = weatherType = weather == null ? StatusType.None : weather.type;
        if (weatherType == StatusType.Sunny) {
            if (pw.getForm().isForm("overcast")) {
                pw.setForm("sunshine");
                pw.bc.sendToAll("pixelmon.abilities.changeform", pw.getNickname());
            }
        } else if (pw.getForm().isForm("sunshine")) {
            pw.setForm("overcast");
            pw.bc.sendToAll("pixelmon.abilities.changeform", pw.getNickname());
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        this.resetForm(newPokemon);
        this.onWeatherChange(newPokemon, newPokemon.bc.globalStatusController.getWeather());
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper pw) {
        this.resetForm(pw);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.onWeatherChange(pokemon, null);
    }

    private void resetForm(PixelmonWrapper pw) {
        if (pw.bc.simulateMode) {
            return;
        }
        if (!pw.getForm().isForm("overcast")) {
            pw.setForm("overcast");
        }
    }
}

