/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;

public class FlashFire
extends AbstractAbility {
    boolean activated = false;

    @Override
    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (a.getType() == Element.FIRE) {
            if (!this.activated) {
                pokemon.bc.sendToAll("pixelmon.abilities.flashfire", pokemon.getNickname());
                a.moveResult.weightMod -= 25.0f;
                this.activated = true;
            } else {
                pokemon.bc.sendToAll("pixelmon.abilities.flashfire2", pokemon.getNickname());
            }
            return false;
        }
        return true;
    }

    @Override
    public int[] modifyPowerAndAccuracyUser(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (this.activated && a.getType() == Element.FIRE) {
            return new int[]{(int)((double)power * 1.5), accuracy};
        }
        return new int[]{power, accuracy};
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        this.activated = false;
    }

    @Override
    public float getMultiplier(AbstractSpawner spawner, SpawnInfo spawnInfo, float sum, float rarity) {
        if (!(spawnInfo instanceof SpawnInfoPokemon)) {
            return 1.0f;
        }
        SpawnInfoPokemon spawnInfoPokemon = (SpawnInfoPokemon)spawnInfo;
        RegistryValue specSpecies = spawnInfoPokemon.getPokemonSpec().getValue(SpeciesRequirement.class).orElse(null);
        if (spawnInfoPokemon.getPokemonSpec() == null || specSpecies == null || !specSpecies.isInitialized()) {
            return 1.0f;
        }
        Species species = spawnInfoPokemon.getSpecies();
        if (species == null) {
            return 1.0f;
        }
        String form = spawnInfoPokemon.getPokemonSpec().getValue(FormRequirement.class).orElse("");
        Stats stats = species.getForm(form);
        if (stats == null || stats.getTypes() == null) {
            return 1.0f;
        }
        return stats.getTypes().contains(Element.FIRE) ? 5.0f : 1.0f;
    }
}

