/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Commanded;
import com.pixelmonmod.pixelmon.battles.status.InMouth;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class Commander
extends AbstractAbility {
    private static boolean isDondozo(PixelmonWrapper pw) {
        return pw.getSpecies().is(PixelmonSpecies.DONDOZO);
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper pw) {
        for (PixelmonWrapper ally : pw.bc.getTeamPokemon(pw)) {
            if (!Commander.isDondozo(ally) || ally.hasStatus(StatusType.Commanded)) continue;
            this.applyEffect(pw, ally);
            break;
        }
    }

    @Override
    public void applyAllySwitchInEffect(PixelmonWrapper pw, PixelmonWrapper switched) {
        if (Commander.isDondozo(switched) && !switched.hasStatus(StatusType.Commanded)) {
            this.applyEffect(pw, switched);
        }
    }

    @Override
    public void onAllyFaint(PixelmonWrapper pw, PixelmonWrapper fainted, PixelmonWrapper source) {
        InMouth status = (InMouth)pw.getStatus(StatusType.InMouth);
        if (status != null && status.isPartnerDondozo(fainted)) {
            pw.removeStatus(status, false);
            fainted.removeStatus(StatusType.Commanded, false);
        }
    }

    @Override
    public void onSelfFaint(PixelmonWrapper self, PixelmonWrapper source) {
        self.removeStatus(StatusType.InMouth, false);
    }

    private void applyEffect(PixelmonWrapper commander, PixelmonWrapper commanded) {
        if (!commander.getParticipant().equals(commanded.getParticipant())) {
            return;
        }
        if (commander.hasStatus(StatusType.Transformed)) {
            return;
        }
        this.sendActivatedMessage(commander);
        Commanded commandedStatus = new Commanded(commander);
        commanded.addStatus(commandedStatus, commander);
        InMouth inMouth = new InMouth(commanded);
        commander.addStatus(inMouth, commander);
        commander.attack = null;
        commanded.getBattleStats().modifyStat(2, BattleStatsType.ATTACK, BattleStatsType.DEFENSE, BattleStatsType.SPECIAL_ATTACK, BattleStatsType.SPECIAL_DEFENSE, BattleStatsType.SPEED);
    }
}

