/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.ExtraStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PokemonBuilder {
    private UUID uuid = null;
    private Species species = PixelmonSpecies.MISSINGNO.getValueUnsafe();
    private String palette = null;
    private String form = null;
    private boolean egg = false;
    private Gender gender = Gender.MALE;
    private int slot = -1;
    private boolean usesHidden = false;
    private Ability ability = null;
    private ITextComponent nickname = null;
    private ItemStack heldItem = new ItemStack((IItemProvider)NoItem.noItem);
    private int friendship = -1;
    private int[] ivs = new int[6];
    private int[] evs = new int[6];
    private Attack[] moves = new Attack[4];
    private Nature nature = null;
    private Nature mintNature = null;
    private int level = 0;
    private int experience = 0;
    private EnumGrowth growth = null;
    private PokeBall caughtBall = null;
    private ExtraStats extraStats = null;
    private UUID originalTrainer = null;
    private String originalTrainerName = null;
    private Pokerus pokerus = null;
    private StatusPersist status = null;
    private boolean gigantamaxFactor = false;
    private List<String> flags = Lists.newArrayList();
    private List<String> pokemonSpecs = Lists.newArrayList();

    private PokemonBuilder() {
    }

    public static PokemonBuilder copy(Pokemon pokemon) {
        return new PokemonBuilder().species(pokemon.getSpecies()).form(pokemon.getForm().getName()).palette(pokemon.getPalette().getName()).gender(pokemon.getGender()).ability(pokemon.getAbility()).nickname(pokemon.getFormattedNickname()).heldItem(pokemon.getHeldItem()).friendship(pokemon.getFriendship()).ivs(pokemon.getIVs().getArray()).evs(pokemon.getEVs().getArray()).moves((Attack[])pokemon.getMoveset().stream().map(attack -> attack == null ? null : attack.deepCopy()).toArray(Attack[]::new)).nature(pokemon.getNature()).mintNature(pokemon.getMintNature()).level(pokemon.getPokemonLevel()).growth(pokemon.getGrowth()).caughtBall(pokemon.getBall()).extraStats(pokemon.getExtraStats()).originalTrainer(pokemon.getOriginalTrainerUUID(), pokemon.getOriginalTrainer()).pokerus(pokemon.getPokerus()).status(pokemon.getStatus()).flags(pokemon.flags).egg(pokemon.isEgg()).experience(pokemon.getExperience());
    }

    public static PokemonBuilder builder() {
        return new PokemonBuilder();
    }

    public PokemonBuilder uuid(@Nullable UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public PokemonBuilder randomSpecies() {
        return this.species(PixelmonSpecies.getRandomSpecies());
    }

    public PokemonBuilder randomSpecies(boolean excludeLegendaries, boolean excludeMythicals, boolean excludeUltraBeasts) {
        return this.species(PixelmonSpecies.getRandomSpecies(excludeLegendaries, excludeMythicals, excludeUltraBeasts));
    }

    public PokemonBuilder randomSpecies(Collection<RegistryValue<Species>> excluded) {
        HashSet excludedSet = Sets.newHashSet(excluded);
        return this.randomSpecies(excludedSet::contains);
    }

    public PokemonBuilder randomSpecies(RegistryValue<Species> ... excluded) {
        HashSet excludedSet = Sets.newHashSet((Object[])excluded);
        return this.randomSpecies(excludedSet::contains);
    }

    public PokemonBuilder randomSpecies(Predicate<Species> excluded) {
        Species species = PixelmonSpecies.getRandomSpecies();
        while (excluded.test(species)) {
            species = PixelmonSpecies.getRandomSpecies();
        }
        return this.species(species);
    }

    public PokemonBuilder species(@NonNull String speciesName) {
        Optional<RegistryValue<Species>> speciesRegistryValue = PixelmonSpecies.get(speciesName);
        speciesRegistryValue.ifPresent(this::species);
        return this;
    }

    public PokemonBuilder species(@NonNull RegistryValue<Species> species) {
        species.ifInitialized(this::species);
        return this;
    }

    public PokemonBuilder species(@NonNull Optional<Species> species) {
        species.ifPresent(this::species);
        return this;
    }

    public PokemonBuilder species(int ndex) {
        return this.species(PixelmonSpecies.fromDex(ndex));
    }

    public PokemonBuilder species(@NonNull Species species) {
        this.species = species;
        return this;
    }

    public PokemonBuilder makeEgg() {
        return this.egg(true);
    }

    public PokemonBuilder egg(boolean egg) {
        this.egg = egg;
        return this;
    }

    public PokemonBuilder gender(@NonNull Gender gender) {
        this.gender = gender;
        return this;
    }

    public PokemonBuilder shiny() {
        return this.shiny(true);
    }

    public PokemonBuilder shiny(boolean shiny) {
        if (shiny) {
            return this.palette("shiny");
        }
        return this.palette(null);
    }

    public PokemonBuilder palette(@Nullable String palette) {
        this.palette = palette;
        return this;
    }

    public PokemonBuilder form(@NonNull Stats form) {
        return this.form(form.getName());
    }

    public PokemonBuilder form(@Nullable String form) {
        this.form = form;
        return this;
    }

    public PokemonBuilder ability(@Nullable Ability ability) {
        this.ability = ability;
        return this;
    }

    public PokemonBuilder abilitySlot(Pair<Integer, Boolean> abilitySlot) {
        this.slot = (Integer)abilitySlot.getFirst();
        this.usesHidden = (Boolean)abilitySlot.getSecond();
        return this;
    }

    public PokemonBuilder nickname(@Nullable String nickname) {
        this.nickname(TextHelper.colour(nickname));
        return this;
    }

    public PokemonBuilder nickname(@Nullable ITextComponent nickname) {
        this.nickname = nickname;
        return this;
    }

    public PokemonBuilder heldItem(@NonNull HeldItem heldItem) {
        return this.heldItem(new ItemStack((IItemProvider)heldItem, 1));
    }

    public PokemonBuilder heldItem(@NonNull ItemStack heldItem) {
        this.heldItem = heldItem;
        return this;
    }

    public PokemonBuilder friendship(int friendship) {
        this.friendship = friendship;
        return this;
    }

    public PokemonBuilder experience(int experience) {
        this.experience = experience;
        return this;
    }

    public PokemonBuilder ev(@NonNull BattleStatsType type, int level) {
        this.evs[type.getBattleStatIndex()] = level;
        return this;
    }

    public PokemonBuilder iv(@NonNull BattleStatsType type, int level) {
        this.ivs[type.getBattleStatIndex()] = level;
        return this;
    }

    public PokemonBuilder evs(int ... evs) {
        if (evs.length != 6) {
            throw new RuntimeException("Must have 6 EVs in the array");
        }
        this.evs = evs;
        return this;
    }

    public PokemonBuilder ivs(int ... ivs) {
        if (ivs.length != 6) {
            throw new RuntimeException("Must have 6 IVs in the array");
        }
        this.ivs = ivs;
        return this;
    }

    public PokemonBuilder move(int index, @Nullable ImmutableAttack attack) {
        if (attack == null) {
            return this.move(index, (Attack)null);
        }
        return this.move(index, attack.ofMutable());
    }

    public PokemonBuilder move(int index, @Nullable Attack attack) {
        if (index < 0 || index > 3) {
            throw new RuntimeException("Pokemon can only have 4 attacks!");
        }
        this.moves[index] = attack;
        return this;
    }

    public PokemonBuilder moves(Attack ... moves) {
        Objects.requireNonNull(moves);
        this.moves = moves;
        return this;
    }

    public PokemonBuilder nature(@Nullable Nature nature) {
        this.nature = nature;
        return this;
    }

    public PokemonBuilder growth(@Nullable EnumGrowth growth) {
        this.growth = growth;
        return this;
    }

    public PokemonBuilder mintNature(@Nullable Nature nature) {
        this.mintNature = this.mintNature;
        return this;
    }

    public PokemonBuilder level(int level) {
        this.level = level;
        return this;
    }

    public PokemonBuilder caughtBall(@NonNull PokeBall caughtBall) {
        this.caughtBall = caughtBall;
        return this;
    }

    public PokemonBuilder extraStats(@NonNull ExtraStats extraStats) {
        this.extraStats = extraStats;
        return this;
    }

    public PokemonBuilder originalTrainer(@Nullable UUID originalTrainer, @Nullable String originalTrainerName) {
        this.originalTrainer = originalTrainer;
        this.originalTrainerName = originalTrainerName;
        return this;
    }

    public PokemonBuilder originalTrainer(@Nullable PlayerEntity player) {
        if (player == null) {
            this.originalTrainer(null, null);
        } else {
            this.originalTrainer(player.func_110124_au(), player.func_200200_C_().getString());
        }
        return this;
    }

    public PokemonBuilder specs(String ... specs) {
        this.pokemonSpecs.addAll(Lists.newArrayList((Object[])specs));
        return this;
    }

    public PokemonBuilder specs(Collection<String> specs) {
        this.pokemonSpecs.addAll(specs);
        return this;
    }

    public PokemonBuilder specs(PokemonSpecification ... specs) {
        for (PokemonSpecification spec : specs) {
            this.specs(spec.toString());
        }
        return this;
    }

    public PokemonBuilder pokerus(@NonNull Pokerus pokerus) {
        this.pokerus = pokerus;
        return this;
    }

    public PokemonBuilder status(@NonNull StatusPersist status) {
        this.status = status;
        return this;
    }

    public PokemonBuilder gigantamaxFactor() {
        return this.gigantamaxFactor(true);
    }

    public PokemonBuilder gigantamaxFactor(boolean gigantamaxFactor) {
        this.gigantamaxFactor = gigantamaxFactor;
        return this;
    }

    public PokemonBuilder flags(String ... flags) {
        this.flags.addAll(Lists.newArrayList((Object[])flags));
        return this;
    }

    public PokemonBuilder flags(Collection<String> flags) {
        this.flags.addAll(flags);
        return this;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Species getSpecies() {
        return this.species;
    }

    public String getPalette() {
        return this.palette;
    }

    public String getForm() {
        return this.form;
    }

    public boolean isEgg() {
        return this.egg;
    }

    public Gender getGender() {
        return this.gender;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public ITextComponent getNickname() {
        return this.nickname;
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public int getFriendship() {
        return this.friendship;
    }

    public int[] getIvs() {
        return this.ivs;
    }

    public int[] getEvs() {
        return this.evs;
    }

    public Attack[] getMoves() {
        return this.moves;
    }

    public Nature getNature() {
        return this.nature;
    }

    public Nature getMintNature() {
        return this.mintNature;
    }

    public int getLevel() {
        return this.level;
    }

    public int getExperience() {
        return this.experience;
    }

    public EnumGrowth getGrowth() {
        return this.growth;
    }

    public PokeBall getCaughtBall() {
        return this.caughtBall;
    }

    public ExtraStats getExtraStats() {
        return this.extraStats;
    }

    public UUID getOriginalTrainer() {
        return this.originalTrainer;
    }

    public String getOriginalTrainerName() {
        return this.originalTrainerName;
    }

    public Pokerus getPokerus() {
        return this.pokerus;
    }

    public StatusPersist getStatus() {
        return this.status;
    }

    public boolean isGigantamaxFactor() {
        return this.gigantamaxFactor;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public List<String> getPokemonSpecs() {
        return this.pokemonSpecs;
    }

    public Pokemon build() {
        Stats foundForm;
        Pokemon pokemon = new Pokemon();
        pokemon.setSpecies(this.species, false);
        if (this.uuid != null) {
            pokemon.setUUID(this.uuid);
        }
        if (this.form != null && (foundForm = this.species.getForm(this.form)) != null) {
            pokemon.setForm(foundForm);
        }
        if (this.gender != null) {
            pokemon.setGender(this.gender);
        }
        if (this.palette == null) {
            pokemon.setPalette(pokemon.getGenderProperties().getDefaultPalette());
        } else {
            PaletteProperties foundPalette = pokemon.getGenderProperties().getPalette(this.palette);
            if (foundPalette != null) {
                pokemon.setPalette(foundPalette);
            }
        }
        if (this.slot != -1) {
            pokemon.setHA(this.usesHidden);
            pokemon.setAbilitySlot(this.slot);
            this.ability = pokemon.getForm().getAbilities().resolveAbility(this.slot, this.usesHidden);
            pokemon.setAbility(this.ability);
        } else if (this.ability != null) {
            pokemon.setAbility(this.ability);
            pokemon.overrideAbilitySlot();
        }
        if (this.nickname != null) {
            pokemon.setNickname(this.nickname);
        }
        if (this.heldItem != null) {
            pokemon.setHeldItem(this.heldItem);
        }
        if (this.egg) {
            pokemon.makeEgg();
        }
        pokemon.setExperience(this.experience);
        pokemon.setLevel(this.level);
        pokemon.setFriendship(this.friendship);
        pokemon.setGigantamaxFactor(this.gigantamaxFactor);
        if (this.ivs != null) {
            pokemon.getIVs().fillFromArray(this.ivs);
        }
        if (this.evs != null) {
            pokemon.getEVs().fillFromArray(this.evs);
        }
        if (this.moves != null) {
            for (int i = 0; i < this.moves.length; ++i) {
                pokemon.getMoveset().set(i, this.moves[i]);
            }
        }
        if (this.nature != null) {
            pokemon.setNature(this.nature);
        }
        if (this.growth != null) {
            pokemon.setGrowth(this.growth);
        }
        if (this.mintNature != null) {
            pokemon.setMintNature(this.mintNature);
        }
        if (this.caughtBall != null) {
            pokemon.setBall(this.caughtBall);
        }
        if (this.extraStats != null) {
            pokemon.extraStats = this.extraStats;
        }
        if (this.originalTrainer != null) {
            pokemon.setOriginalTrainer(this.originalTrainer, this.originalTrainerName);
        }
        if (this.pokerus != null) {
            pokemon.setPokerus(this.pokerus);
        }
        if (this.status != null) {
            pokemon.setStatus(this.status);
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            for (String flag : this.flags) {
                pokemon.addFlag(flag);
            }
        }
        if (this.pokemonSpecs != null && !this.pokemonSpecs.isEmpty()) {
            for (String pokemonSpec : this.pokemonSpecs) {
                PokemonSpecification specification = PokemonSpecificationProxy.create(pokemonSpec);
                specification.apply(pokemon);
            }
        }
        pokemon.initialize(InitializeCategory.EMPTY);
        return pokemon;
    }
}

