/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.overlay.scoreboard.line;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.line.ScoreboardEntry;
import java.awt.Color;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ScoreboardLine {
    private boolean title;
    private float height;
    private float width;
    private int line;
    private List<ScoreboardEntry> entries;
    private boolean hideBackground;
    private Color backgroundColor;
    private boolean wrapWidth = false;

    public ScoreboardLine(boolean title, float height, float width, int line, List<ScoreboardEntry> entries, boolean hideBackground, Color backgroundColor) {
        this.title = title;
        this.height = height;
        this.width = width;
        this.line = line;
        this.entries = entries;
        this.hideBackground = hideBackground;
        this.backgroundColor = backgroundColor;
    }

    public ScoreboardLine() {
    }

    public boolean isTitle() {
        return this.title;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public int getLine() {
        return this.line;
    }

    public List<ScoreboardEntry> getEntries() {
        return this.entries;
    }

    public boolean isHideBackground() {
        return this.hideBackground;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public ScoreboardLine title() {
        return this.title(true);
    }

    public boolean isWrapWidth() {
        return this.wrapWidth;
    }

    public ScoreboardLine title(boolean title) {
        this.title = title;
        return this;
    }

    public ScoreboardLine width(float width) {
        this.width = width;
        return this;
    }

    public ScoreboardLine height(float height) {
        this.height = height;
        return this;
    }

    public ScoreboardLine line(int line) {
        this.line = line;
        return this;
    }

    public ScoreboardLine hideBackground() {
        this.hideBackground = true;
        return this;
    }

    public ScoreboardLine showBackground() {
        this.hideBackground = false;
        return this;
    }

    public ScoreboardLine backgroundColor(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public ScoreboardLine entry(ScoreboardEntry ... entry) {
        this.entries.addAll(Lists.newArrayList((Object[])entry));
        return this;
    }

    public ScoreboardLine clearEntries() {
        this.entries.clear();
        return this;
    }

    public ScoreboardLine wrapWidth(boolean wrapWidth) {
        this.wrapWidth = wrapWidth;
        return this;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.title);
        buffer.writeFloat(this.height);
        buffer.writeFloat(this.width);
        buffer.writeInt(this.line);
        buffer.writeBoolean(this.hideBackground);
        buffer.writeBoolean(this.wrapWidth);
        buffer.writeBoolean(this.backgroundColor != null);
        if (this.backgroundColor != null) {
            buffer.writeInt(this.backgroundColor.getRGB());
        }
        buffer.writeInt(this.entries.size());
        for (ScoreboardEntry entry : this.entries) {
            entry.encode(buffer);
        }
    }

    public void decode(PacketBuffer buffer) {
        this.title = buffer.readBoolean();
        this.height = buffer.readFloat();
        this.width = buffer.readFloat();
        this.line = buffer.readInt();
        this.hideBackground = buffer.readBoolean();
        this.wrapWidth = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.backgroundColor = new Color(buffer.readInt());
        }
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render() {
    }
}

