/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.overlay.scoreboard;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.BoardPosition;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.Scoreboard;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.line.ScoreboardEntry;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.type.ScreenBoardPosition;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.type.WorldBoardPosition;
import com.pixelmonmod.pixelmon.api.util.TargetPoint;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ScoreboardFactory {
    public static final Map<String, Supplier<? extends ScoreboardEntry>> REGISTERED_ENTRIES = Maps.newConcurrentMap();
    public static final Map<String, Function<PacketBuffer, ? extends BoardPosition>> REGISTERED_POSITIONS = Maps.newConcurrentMap();
    private static final Map<UUID, Scoreboard> PLAYER_SCOREBOARDS = Maps.newConcurrentMap();
    private static final Map<TargetPoint, Scoreboard> POSITION_SCOREBOARDS = Maps.newConcurrentMap();

    public static void init() {
        Timer timer = new Timer("pixelmon-scoreboard");
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ScoreboardFactory.sendPackets();
            }
        }, 50L, 50L);
    }

    public static void addPositionBoard(TargetPoint point, Scoreboard scoreboard) {
        POSITION_SCOREBOARDS.put(point, scoreboard);
    }

    public static void removePositionBoard(TargetPoint point) {
        POSITION_SCOREBOARDS.remove(point);
    }

    public static void addPlayerBoard(ServerPlayerEntity target, Scoreboard scoreboard) {
        PLAYER_SCOREBOARDS.put(target.func_110124_au(), scoreboard);
    }

    public static void removePlayerBoard(ServerPlayerEntity target) {
        ScoreboardFactory.removePlayerBoard(target.func_110124_au());
    }

    public static void removePlayerBoard(UUID uuid) {
        PLAYER_SCOREBOARDS.remove(uuid);
    }

    public static BoardPosition get(String name, PacketBuffer buffer) {
        Function<PacketBuffer, ? extends BoardPosition> packetBufferFunction = REGISTERED_POSITIONS.get(name.toLowerCase(Locale.ROOT));
        if (packetBufferFunction == null) {
            return null;
        }
        return packetBufferFunction.apply(buffer);
    }

    public static void sendPackets() {
        for (Map.Entry<UUID, Scoreboard> entry : PLAYER_SCOREBOARDS.entrySet()) {
            ServerPlayerEntity serverPlayer = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(entry.getKey());
            if (serverPlayer != null) continue;
        }
    }

    static {
        REGISTERED_POSITIONS.put("screen", ScreenBoardPosition::decide);
        REGISTERED_POSITIONS.put("world", packetBuffer -> {
            WorldBoardPosition position = new WorldBoardPosition();
            position.decode((PacketBuffer)packetBuffer);
            return position;
        });
    }
}

