/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.raids;

import com.pixelmonmod.pixelmon.entities.DenEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class DenEvent
extends Event {
    private final DenEntity den;

    public DenEvent(DenEntity den) {
        this.den = den;
    }

    public DenEntity getDen() {
        return this.den;
    }

    public static class Collide
    extends DenEvent {
        private final Entity entity;

        public Collide(DenEntity den, Entity entity) {
            super(den);
            this.entity = entity;
        }

        public Entity getPlayer() {
            return this.entity;
        }
    }

    @Cancelable
    public static class Interact
    extends DenEvent {
        private final PlayerEntity player;
        private final boolean rightClick;

        public Interact(DenEntity den, PlayerEntity player, boolean rightClick) {
            super(den);
            this.player = player;
            this.rightClick = rightClick;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public boolean wasRightClick() {
            return this.rightClick;
        }

        public boolean wasLeftClick() {
            return !this.rightClick;
        }
    }
}

