/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.battles;

import com.google.common.collect.ImmutableMap;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleResults;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEvent;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class BattleEndEvent
extends BattleEvent {
    protected final BattleEndCause cause;
    protected final boolean abnormal;
    protected final ImmutableMap<BattleParticipant, BattleResults> results;

    public BattleEndEvent(BattleController bc, BattleEndCause cause, boolean abnormal, HashMap<BattleParticipant, BattleResults> results) {
        super(bc);
        this.cause = cause;
        this.abnormal = abnormal;
        this.results = ImmutableMap.copyOf(results);
    }

    public BattleEndCause getCause() {
        return this.cause;
    }

    public boolean isAbnormal() {
        return this.abnormal;
    }

    public Map<BattleParticipant, BattleResults> getResults() {
        return this.results;
    }

    public Optional<BattleResults> getResult(Entity entity) {
        for (Map.Entry entry : this.results.entrySet()) {
            if (!Objects.equals(entity, ((BattleParticipant)entry.getKey()).getEntity())) continue;
            return Optional.ofNullable(entry.getValue());
        }
        return Optional.empty();
    }

    public List<ServerPlayerEntity> getPlayers() {
        return this.getBattleController().getPlayerEntities();
    }
}

