/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.daycare.impl.requirement;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.AbstractRequirement;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.util.helpers.ItemStackHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class ItemStackRequirement
extends AbstractRequirement {
    protected List<ItemStack> requiredItems = Lists.newArrayList();

    public ItemStackRequirement() {
        super("itemstack");
    }

    @Override
    public void read(Gson gson, JsonElement json) throws RuntimeException {
        JsonObject object = json.getAsJsonObject();
        this.error = TextHelper.colour(object.get("error_message").getAsString());
        if (!object.has("items")) {
            return;
        }
        for (JsonElement items : object.getAsJsonArray("items")) {
            JsonObject itemObject = items.getAsJsonObject();
            ItemStackHelper.parseUserInput(itemObject.get("item").getAsString(), itemObject.get("amount").getAsInt()).ifPresent(this.requiredItems::add);
        }
    }

    @Override
    public boolean hasMetRequirement(ServerPlayerEntity player, DayCareBox box) {
        for (ItemStack requiredItem : this.requiredItems) {
            int found = 0;
            for (ItemStack item : player.field_71071_by.field_70462_a) {
                if (item.func_190926_b() || !this.isSameItem(requiredItem, item) || (found += item.func_190916_E()) < requiredItem.func_190916_E()) continue;
                return true;
            }
            if (found >= requiredItem.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void takeFrom(ServerPlayerEntity player, DayCareBox box) {
        block0: for (ItemStack requiredItem : this.requiredItems) {
            int slotMatchingItem;
            ItemStack remove;
            for (int amount = requiredItem.func_190916_E(); amount > 0 && (slotMatchingItem = this.findSlotMatchingItem(player, requiredItem)) != -1; amount -= remove.func_190916_E()) {
                remove = player.field_71071_by.func_70301_a(slotMatchingItem);
                if (remove.func_190916_E() == amount) {
                    player.field_71071_by.func_70299_a(slotMatchingItem, ItemStack.field_190927_a);
                    continue block0;
                }
                if (remove.func_190916_E() > amount) {
                    remove.func_190918_g(amount);
                    continue block0;
                }
                player.field_71071_by.func_70299_a(slotMatchingItem, ItemStack.field_190927_a);
            }
        }
        player.field_71071_by.func_70296_d();
    }

    private int findSlotMatchingItem(ServerPlayerEntity player, ItemStack item) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || !this.isSameItem(item, (ItemStack)player.field_71071_by.field_70462_a.get(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean isSameItem(ItemStack p_184431_1_, ItemStack p_184431_2_) {
        return p_184431_1_.func_77973_b() == p_184431_2_.func_77973_b() && ItemStack.func_77970_a((ItemStack)p_184431_1_, (ItemStack)p_184431_2_);
    }

    @Override
    public void write(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (ItemStack requiredItem : this.requiredItems) {
            CompoundNBT itemNbt = new CompoundNBT();
            itemNbt.func_218657_a("item", (INBT)requiredItem.serializeNBT());
            list.add((Object)itemNbt);
        }
        ListNBT itemRequirementList = new ListNBT();
        if (nbt.func_74764_b("itemRequirement")) {
            itemRequirementList = nbt.func_150295_c("itemRequirement", 9);
        }
        itemRequirementList.add((Object)list);
        nbt.func_218657_a("itemRequirement", (INBT)itemRequirementList);
    }

    @Override
    public void read(CompoundNBT nbt) {
        if (!nbt.func_74764_b("itemRequirement")) {
            return;
        }
        ListNBT itemRequirementList = nbt.func_150295_c("itemRequirement", 9);
        if (itemRequirementList.isEmpty()) {
            return;
        }
        ListNBT list = itemRequirementList.func_202169_e(0);
        itemRequirementList.remove(0);
        for (INBT inbt : list) {
            this.requiredItems.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt).func_74775_l("item")));
        }
    }

    public List<ItemStack> getRequiredItems() {
        return this.requiredItems;
    }
}

