/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.requirement;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.requirement.Requirement;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractRequirement<A, B, C>
implements Requirement<A, B, C> {
    protected final Set<String> keys;

    public AbstractRequirement(Set<String> keys) {
        this.keys = keys;
    }

    @Override
    public List<String> getAliases() {
        return Lists.newArrayList(this.keys);
    }

    @Override
    public boolean fits(String spec) {
        for (String subSpec : spec.split(" ")) {
            for (String key : this.keys) {
                if (!subSpec.startsWith(key + ":") && !subSpec.equalsIgnoreCase(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Requirement<A, B, ?>> create(String spec) {
        for (String subSpec : spec.split(" ")) {
            for (String key : this.keys) {
                if (!subSpec.startsWith(key + ":") && !subSpec.equalsIgnoreCase(key)) continue;
                return this.createSimple(key, subSpec);
            }
        }
        return Collections.emptyList();
    }

    public abstract List<Requirement<A, B, ?>> createSimple(String var1, String var2);
}

