/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.api.EmptySpecification;
import com.pixelmonmod.api.Specification;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.Pixelmon;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;

public class SpecificationFactory {
    private static final Map<Class<? extends Specification<?, ?>>, SpecTypeData<?, ?, ?>> REGISTERED_REQUIREMENTS = Maps.newHashMap();

    public static <A, B, C extends Specification<A, B>> void register(Class<C> clazz, Requirement<A, B, ?> requirement) {
        SpecTypeData specTypeData = REGISTERED_REQUIREMENTS.computeIfAbsent(clazz, ___ -> new SpecTypeData(clazz));
        specTypeData.getRequirements().add(requirement);
        specTypeData.getRequirements().sort(Comparator.comparing(o -> ((Requirement)o).getPriority()).reversed());
        for (String alias : requirement.getAliases()) {
            specTypeData.getRequirementNames().add(alias.trim());
        }
    }

    public static <A, B> List<Requirement<A, B, ?>> requirements(Class<? extends Specification<A, B>> specification, String spec) {
        if (!REGISTERED_REQUIREMENTS.containsKey(specification)) {
            return Collections.emptyList();
        }
        ArrayList requirements = Lists.newArrayList();
        SpecTypeData<?, ?, ?> specTypeData = REGISTERED_REQUIREMENTS.get(specification);
        for (Requirement<?, ?, ?> registeredRequirement : specTypeData.getRequirements()) {
            if (!registeredRequirement.fits(spec)) continue;
            requirements.addAll(registeredRequirement.create(spec));
            if (registeredRequirement.shouldContinue()) continue;
            break;
        }
        return requirements;
    }

    public static <A, B> Specification<A, B> create(Class<? extends Specification<A, B>> clazz, String ... specs) {
        StringBuilder builder = new StringBuilder();
        for (String spec : specs) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(spec);
        }
        SpecTypeData<?, ?, ?> specTypeData = REGISTERED_REQUIREMENTS.get(clazz);
        if (specTypeData == null) {
            return null;
        }
        try {
            return (Specification)specTypeData.getConstructor().newInstance(builder.toString(), SpecificationFactory.requirements(clazz, builder.toString()));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Pixelmon.LOGGER.error("Couldn't construct " + clazz.getSimpleName() + " specification");
            e.printStackTrace();
            return null;
        }
    }

    public static <A, B> Specification<A, B> create(Class<? extends Specification<A, B>> clazz, Object ... args) {
        String spec = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(" "));
        SpecTypeData<?, ?, ?> specTypeData = REGISTERED_REQUIREMENTS.get(clazz);
        if (specTypeData == null) {
            return null;
        }
        try {
            return (Specification)specTypeData.getConstructor().newInstance(spec, SpecificationFactory.requirements(clazz, spec));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Pixelmon.LOGGER.error("Couldn't construct " + clazz.getSimpleName() + " specification");
            e.printStackTrace();
            return null;
        }
    }

    public static Specification<?, ?> empty() {
        return EmptySpecification.INSTANCE;
    }

    public static String[] getRequirementNames(Class<? extends Specification<?, ?>> clazz) {
        SpecTypeData<?, ?, ?> specTypeData = REGISTERED_REQUIREMENTS.get(clazz);
        if (specTypeData == null) {
            return new String[0];
        }
        return specTypeData.getRequirementNames().toArray(new String[0]);
    }

    public static <A, B> Specification<A, B> fromNbt(Class<? extends Specification<A, B>> clazz, CompoundNBT nbt) {
        if (!nbt.func_74764_b("SpecificationData")) {
            return SpecificationFactory.create(clazz, new String[0]);
        }
        return SpecificationFactory.create(clazz, nbt.func_74779_i("SpecificationData"));
    }

    private static class SpecTypeData<C, A, B> {
        private Constructor<C> constructor;
        private List<Requirement<A, B, ?>> requirements = Lists.newArrayList();
        private List<String> requirementNames = Lists.newArrayList();

        private SpecTypeData(Class<C> clazz) {
            try {
                this.constructor = clazz.getConstructor(String.class, List.class);
            }
            catch (NoSuchMethodException e) {
                Pixelmon.LOGGER.error("Couldn't construct " + clazz.getSimpleName() + " specification");
                e.printStackTrace();
            }
        }

        public Constructor<C> getConstructor() {
            return this.constructor;
        }

        public List<Requirement<A, B, ?>> getRequirements() {
            return this.requirements;
        }

        public List<String> getRequirementNames() {
            return this.requirementNames;
        }
    }
}

