/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.UsernameCache;

public class PlayerRenderer {
    private static final Map<UUID, GameProfile> PLAYER_PROFILE_MAP = new HashMap<UUID, GameProfile>();
    private static final HashSet<UUID> FETCH_QUEUE = new HashSet();

    public static void renderPlayerHead(UUID player, MatrixStack poseStack, int x, int y, int width, int height) {
        ScreenUtils.bindTexture((ResourceLocation)PlayerRenderer.getPlayerSkin(player));
        ScreenUtils.drawTexture((MatrixStack)poseStack, (float)x, (float)y, (float)width, (float)height, (float)0.125f, (float)0.125f, (float)0.125f, (float)0.125f);
    }

    public static String getPlayerUsername(UUID player) {
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        return profile == null ? UsernameCache.getLastKnownUsername((UUID)player) : profile.getName();
    }

    public static ResourceLocation getPlayerSkin(UUID player) {
        SkinManager skinManager;
        Map map;
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        if (profile != null && (map = (skinManager = ClientUtils.getMinecraft().func_152342_ad()).func_152788_a(profile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return skinManager.func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        return DefaultPlayerSkin.func_177334_a((UUID)player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GameProfile fetchPlayerProfile(UUID player) {
        Object object = PLAYER_PROFILE_MAP;
        synchronized (object) {
            GameProfile profile = PLAYER_PROFILE_MAP.get(player);
            if (profile != null) {
                return profile;
            }
        }
        object = FETCH_QUEUE;
        synchronized (object) {
            if (FETCH_QUEUE.add(player)) {
                new Thread(() -> {
                    GameProfile profile;
                    boolean success = false;
                    String name = PlayerRenderer.fetchPlayerName(player);
                    if (name != null && (profile = PlayerRenderer.updateGameProfile(new GameProfile(player, name))) != null) {
                        Map<UUID, GameProfile> map = PLAYER_PROFILE_MAP;
                        synchronized (map) {
                            PLAYER_PROFILE_MAP.put(player, profile);
                        }
                        success = true;
                    }
                    if (!success) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    HashSet<UUID> hashSet = FETCH_QUEUE;
                    synchronized (hashSet) {
                        FETCH_QUEUE.remove(player);
                    }
                }, "Tesseract - Game profile fetching").start();
            }
        }
        return null;
    }

    @Nullable
    private static GameProfile updateGameProfile(@Nullable GameProfile input) {
        if (input != null && input.getId() != null) {
            MinecraftSessionService sessionService = PlayerRenderer.getSessionService();
            return sessionService.fillProfileProperties(input, true);
        }
        return null;
    }

    private static String fetchPlayerName(UUID player) {
        try {
            JsonObject json;
            String s;
            InputStream inputStream = new URL("https://api.mojang.com/user/profile/" + player).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder builder = new StringBuilder();
            while ((s = reader.readLine()) != null) {
                builder.append(s);
            }
            if (builder.length() > 0 && (json = JSONUtils.func_212745_a((String)builder.toString())).has("name")) {
                return json.get("name").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static MinecraftSessionService getSessionService() {
        return ClientUtils.getMinecraft().func_152347_ac();
    }
}

