/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.packets;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class PacketRemoveTesseractReferences
implements BasePacket {
    private Collection<Pair<String, BlockPos>> references;

    public PacketRemoveTesseractReferences(Collection<TesseractReference> references) {
        this.references = references.stream().map(reference -> Pair.of((Object)reference.getDimension(), (Object)reference.getPos())).collect(Collectors.toSet());
    }

    public PacketRemoveTesseractReferences() {
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.references.size());
        for (Pair<String, BlockPos> reference : this.references) {
            buffer.func_180714_a((String)reference.left());
            buffer.func_179255_a((BlockPos)reference.right());
        }
    }

    public void read(PacketBuffer buffer) {
        int size = buffer.readInt();
        this.references = new ArrayList<Pair<String, BlockPos>>(size);
        for (int i = 0; i < size; ++i) {
            this.references.add((Pair<String, BlockPos>)Pair.of((Object)buffer.func_218666_n(), (Object)buffer.func_179259_c()));
        }
    }

    public void handle(PacketContext context) {
        if (context.getHandlingSide().isServer()) {
            return;
        }
        for (Pair<String, BlockPos> reference : this.references) {
            TesseractTracker.CLIENT.remove((String)reference.left(), (BlockPos)reference.right());
        }
    }
}

