/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.tesseract.TesseractConfig;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.nio.file.Path;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;

public class TesseractSaveHandler {
    private static long lastSaveTime = 0L;

    public static void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(TesseractSaveHandler::onJoin);
        MinecraftForge.EVENT_BUS.addListener(TesseractSaveHandler::tick);
        MinecraftForge.EVENT_BUS.addListener(TesseractSaveHandler::save);
        MinecraftForge.EVENT_BUS.addListener(TesseractSaveHandler::load);
    }

    private static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        TesseractTracker.sendReferences(e.getPlayer());
        TesseractChannelManager.sendChannels(e.getPlayer());
    }

    private static void tick(TickEvent.WorldTickEvent e) {
        if (e.world.field_72995_K || e.phase != TickEvent.Phase.END || e.world.func_234923_W_() != World.field_234918_g_) {
            return;
        }
        if (System.currentTimeMillis() - lastSaveTime >= (long)(TesseractConfig.saveInterval.get() * 60000)) {
            Path saveDirectory = CommonUtils.getServer().func_240776_a_(FolderName.field_237253_i_);
            TesseractTracker.saveReferences(saveDirectory);
            TesseractChannelManager.saveChannels(saveDirectory);
            lastSaveTime = System.currentTimeMillis();
        }
    }

    private static void save(WorldEvent.Save e) {
        if (e.getWorld().func_201670_d() || !(e.getWorld() instanceof World) || ((World)e.getWorld()).func_234923_W_() != World.field_234918_g_) {
            return;
        }
        Path saveDirectory = CommonUtils.getServer().func_240776_a_(FolderName.field_237253_i_);
        TesseractTracker.saveReferences(saveDirectory);
        TesseractChannelManager.saveChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }

    private static void load(WorldEvent.Load e) {
        if (e.getWorld().func_201670_d() || !(e.getWorld() instanceof World) || ((World)e.getWorld()).func_234923_W_() != World.field_234918_g_) {
            return;
        }
        Path saveDirectory = CommonUtils.getServer().func_240776_a_(FolderName.field_237253_i_);
        TesseractTracker.loadReferences(saveDirectory);
        TesseractChannelManager.loadChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }
}

