/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.capabilities.CombinedEnergyStorage;
import com.supermartijn642.tesseract.capabilities.CombinedFluidHandler;
import com.supermartijn642.tesseract.capabilities.CombinedItemHandler;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;

public class Channel {
    public final int id;
    public final EnumChannelType type;
    public UUID creator;
    public boolean isPrivate = false;
    public String name;
    public final Set<TesseractReference> tesseracts = new LinkedHashSet<TesseractReference>();
    public final Set<TesseractReference> sendingTesseracts = new LinkedHashSet<TesseractReference>();
    public final Set<TesseractReference> receivingTesseracts = new LinkedHashSet<TesseractReference>();

    public Channel(int id, EnumChannelType type, UUID creator, boolean isPrivate, String name) {
        this.id = id;
        this.type = type;
        this.creator = creator;
        this.isPrivate = isPrivate;
        this.name = name;
    }

    public Channel(int id, EnumChannelType type, CompoundNBT compound) {
        this.id = id;
        this.type = type;
        this.read(compound);
    }

    public String getName() {
        return this.name;
    }

    public void addTesseract(TesseractReference tesseract) {
        if (!this.tesseracts.contains(tesseract)) {
            this.tesseracts.add(tesseract);
            if (tesseract.canSend(this.type)) {
                this.sendingTesseracts.add(tesseract);
            }
            if (tesseract.canReceive(this.type)) {
                this.receivingTesseracts.add(tesseract);
            }
            if (tesseract.getChannelId(this.type) != this.id) {
                tesseract.setChannel(this.type, this.id);
            }
        }
    }

    public void removeTesseract(TesseractReference tesseract) {
        this.tesseracts.remove(tesseract);
        this.sendingTesseracts.remove(tesseract);
        this.receivingTesseracts.remove(tesseract);
    }

    public void updateTesseract(TesseractReference tesseract) {
        if (tesseract.canSend(this.type)) {
            this.sendingTesseracts.add(tesseract);
        } else {
            this.sendingTesseracts.remove(tesseract);
        }
        if (tesseract.canReceive(this.type)) {
            this.receivingTesseracts.add(tesseract);
        } else {
            this.receivingTesseracts.remove(tesseract);
        }
    }

    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_186854_a("creator", this.creator);
        compound.func_74757_a("private", this.isPrivate);
        compound.func_74778_a("name", this.name);
        CompoundNBT tesseractCompound = new CompoundNBT();
        Iterator<TesseractReference> iterator = this.tesseracts.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            tesseractCompound.func_218657_a("tesseract" + i, (INBT)TesseractTracker.SERVER.writeKey(iterator.next()));
            ++i;
        }
        compound.func_218657_a("references", (INBT)tesseractCompound);
        return compound;
    }

    public void read(CompoundNBT compound) {
        this.creator = compound.func_186857_a("creator");
        this.isPrivate = compound.func_74767_n("private");
        this.name = compound.func_74779_i("name");
        this.tesseracts.clear();
        this.sendingTesseracts.clear();
        this.receivingTesseracts.clear();
        CompoundNBT tesseractCompound = compound.func_74775_l("references");
        for (String key : tesseractCompound.func_150296_c()) {
            TesseractReference reference = TesseractTracker.SERVER.fromKey(tesseractCompound.func_74775_l(key));
            if (reference == null) continue;
            this.addTesseract(reference);
        }
        if (compound.func_74764_b("tesseracts")) {
            tesseractCompound = compound.func_74775_l("tesseracts");
            for (String key : tesseractCompound.func_150296_c()) {
                BlockPos pos;
                CompoundNBT compound2 = tesseractCompound.func_74775_l(key);
                String dimension = compound2.func_74779_i("dim");
                TesseractReference reference = TesseractTracker.SERVER.getReference(dimension, pos = new BlockPos(compound2.func_74762_e("posx"), compound2.func_74762_e("posy"), compound2.func_74762_e("posz")));
                if (reference == null) continue;
                this.addTesseract(reference);
            }
        }
    }

    public CompoundNBT writeClientChannel() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("id", this.id);
        tag.func_74768_a("type", this.type.getIndex());
        tag.func_186854_a("creator", this.creator);
        tag.func_74757_a("private", this.isPrivate);
        tag.func_74778_a("name", this.name);
        return tag;
    }

    public static Channel readClientChannel(CompoundNBT tag) {
        int id = tag.func_74762_e("id");
        EnumChannelType type = EnumChannelType.byIndex(tag.func_74762_e("type"));
        UUID creator = tag.func_186857_a("creator");
        boolean isPrivate = tag.func_74767_n("private");
        String name = tag.func_74779_i("name");
        return new Channel(id, type, creator, isPrivate, name);
    }

    public CombinedItemHandler getItemHandler(TesseractBlockEntity self) {
        return new CombinedItemHandler(this, self);
    }

    public CombinedFluidHandler getFluidHandler(TesseractBlockEntity self) {
        return new CombinedFluidHandler(this, self);
    }

    public CombinedEnergyStorage getEnergyStorage(TesseractBlockEntity self) {
        return new CombinedEnergyStorage(this, self);
    }

    public int hashCode() {
        return this.id + 31 * this.type.hashCode();
    }

    public void delete() {
        for (TesseractReference location : this.tesseracts) {
            location.setChannel(this.type, -1);
        }
    }
}

