/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlock;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

@WailaPlugin(value="tesseract")
public class TesseractWailaPlugin
implements IComponentProvider,
IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, TesseractBlock.class);
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        TileEntity entity = accessor.getTileEntity();
        if (entity instanceof TesseractBlockEntity) {
            TesseractBlockEntity tesseract = (TesseractBlockEntity)entity;
            tooltip.add((ITextComponent)TextComponents.translation((String)"tesseract.tesseract.highlight.channels").get());
            tooltip.add(TesseractWailaPlugin.formatChannelInfo(EnumChannelType.ITEMS, tesseract.getChannelId(EnumChannelType.ITEMS)));
            tooltip.add(TesseractWailaPlugin.formatChannelInfo(EnumChannelType.ENERGY, tesseract.getChannelId(EnumChannelType.ENERGY)));
            tooltip.add(TesseractWailaPlugin.formatChannelInfo(EnumChannelType.FLUID, tesseract.getChannelId(EnumChannelType.FLUID)));
            if (tesseract.isBlockedByRedstone()) {
                tooltip.add((ITextComponent)TextComponents.translation((String)"tesseract.tesseract.highlight.redstone_blocked").color(TextFormatting.RED).get());
            }
        }
    }

    private static ITextComponent formatChannelInfo(EnumChannelType type, int channelId) {
        Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, channelId);
        IFormattableTextComponent channelType = TextComponents.fromTextComponent((ITextComponent)type.getTranslation()).color(TextFormatting.GOLD).get();
        IFormattableTextComponent separator = TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.separator").get();
        IFormattableTextComponent channelName = channel == null ? TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.inactive").color(TextFormatting.DARK_GRAY).italic().get() : TextComponents.string((String)channel.name).get();
        return TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info", (Object[])new Object[]{channelType, separator, channelName}).get();
    }
}

