/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public class TesseractTheOneProbePlugin {
    public static void interModEnqueue(InterModEnqueueEvent e) {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> new ProbeInfoProvider());
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider,
    IProbeConfigProvider,
    Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe theOneProbe) {
            theOneProbe.registerProvider((IProbeInfoProvider)this);
            theOneProbe.registerProbeConfigProvider((IProbeConfigProvider)this);
            return null;
        }

        public String getID() {
            return "tesseract";
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World level, BlockState state, IProbeHitData probeHitData) {
            TileEntity entity = level.func_175625_s(probeHitData.getPos());
            if (entity instanceof TesseractBlockEntity) {
                TesseractBlockEntity tesseract = (TesseractBlockEntity)entity;
                probeInfo.text((ITextComponent)TextComponents.translation((String)"tesseract.tesseract.highlight.channels").get());
                probeInfo.text(ProbeInfoProvider.formatChannelInfo(EnumChannelType.ITEMS, tesseract.getChannelId(EnumChannelType.ITEMS)));
                probeInfo.text(ProbeInfoProvider.formatChannelInfo(EnumChannelType.ENERGY, tesseract.getChannelId(EnumChannelType.ENERGY)));
                probeInfo.text(ProbeInfoProvider.formatChannelInfo(EnumChannelType.FLUID, tesseract.getChannelId(EnumChannelType.FLUID)));
                if (tesseract.isBlockedByRedstone()) {
                    probeInfo.text((ITextComponent)TextComponents.string((String)TextStyleClass.ERROR.toString()).translation("tesseract.tesseract.highlight.redstone_blocked").get());
                }
            }
        }

        private static ITextComponent formatChannelInfo(EnumChannelType type, int channelId) {
            Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, channelId);
            IFormattableTextComponent channelType = TextComponents.string((String)TextStyleClass.HIGHLIGHTED.toString()).get().func_230529_a_(type.getTranslation());
            IFormattableTextComponent separator = TextComponents.string((String)TextStyleClass.INFO.toString()).translation("tesseract.tesseract.highlight.channel_info.separator").get();
            IFormattableTextComponent channelName = channel == null ? TextComponents.string((String)TextStyleClass.LABEL.toString()).translation("tesseract.tesseract.highlight.channel_info.inactive").get() : TextComponents.string((String)TextStyleClass.INFO.toString()).string(channel.name).get();
            return TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info", (Object[])new Object[]{channelType, separator, channelName}).get();
        }

        public void getProbeConfig(IProbeConfig probeConfig, PlayerEntity player, World level, Entity entity, IProbeHitEntityData probeHitEntityData) {
        }

        public void getProbeConfig(IProbeConfig probeConfig, PlayerEntity player, World level, BlockState state, IProbeHitData probeHitData) {
            if (state.func_177230_c() == Tesseract.tesseract) {
                probeConfig.setRFMode(0);
                probeConfig.setTankMode(0);
            }
        }
    }
}

