/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CombinedItemHandler
implements IItemHandler {
    private final Channel channel;
    private final TesseractBlockEntity requester;

    public CombinedItemHandler(Channel channel, TesseractBlockEntity requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public int getSlots() {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : entity.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return slots;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.pushRecurrentCall()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStack.field_190927_a;
        int slots = 0;
        block0: for (TesseractReference reference : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : entity.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    stack = handler.getStackInSlot(slot - slots);
                    break block0;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.pushRecurrentCall()) {
            return stack;
        }
        if (!this.requester.canSend(EnumChannelType.ITEMS) || stack.func_190926_b()) {
            this.popRecurrentCall();
            return stack;
        }
        ItemStack leftOver = stack;
        int slots = 0;
        block0: for (TesseractReference reference : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : entity.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    leftOver = reference.canReceive(EnumChannelType.ITEMS) ? handler.insertItem(slot - slots, stack, simulate) : stack;
                    break block0;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return leftOver;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.pushRecurrentCall()) {
            return ItemStack.field_190927_a;
        }
        if (!this.requester.canReceive(EnumChannelType.ITEMS) || amount <= 0) {
            this.popRecurrentCall();
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStack.field_190927_a;
        int slots = 0;
        block0: for (TesseractReference reference : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : entity.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    stack = reference.canSend(EnumChannelType.ITEMS) ? handler.extractItem(slot - slots, amount, simulate) : ItemStack.field_190927_a;
                    break block0;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return stack;
    }

    public int getSlotLimit(int slot) {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int limit = 0;
        int slots = 0;
        block0: for (TesseractReference reference : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : entity.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    limit = handler.getSlotLimit(slot - slots);
                    break block0;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return limit;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.pushRecurrentCall()) {
            return false;
        }
        boolean valid = false;
        int slots = 0;
        block0: for (TesseractReference reference : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!reference.canBeAccessed() || (entity = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : entity.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    valid = handler.isItemValid(slot - slots, stack);
                    break block0;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return valid;
    }

    private boolean pushRecurrentCall() {
        if (this.requester.recurrentCalls >= 1) {
            return true;
        }
        ++this.requester.recurrentCalls;
        return false;
    }

    private void popRecurrentCall() {
        --this.requester.recurrentCalls;
    }
}

