/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.RedstoneState;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TransferState;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TesseractBlockEntity
extends BaseBlockEntity {
    private TesseractReference reference;
    private final EnumMap<EnumChannelType, TransferState> transferState = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, LazyOptional<?>> capabilities = new EnumMap(EnumChannelType.class);
    private RedstoneState redstoneState = RedstoneState.DISABLED;
    private boolean redstone;
    public int recurrentCalls = 0;
    private final Map<Direction, Map<Capability<?>, LazyOptional<?>>> surroundingCapabilities = new EnumMap(Direction.class);

    public TesseractBlockEntity() {
        super(Tesseract.tesseract_tile);
        for (EnumChannelType enumChannelType : EnumChannelType.values()) {
            this.transferState.put(enumChannelType, TransferState.BOTH);
        }
        for (EnumChannelType enumChannelType : Direction.values()) {
            this.surroundingCapabilities.put((Direction)enumChannelType, new HashMap());
        }
    }

    public TesseractReference getReference() {
        if (this.reference == null) {
            this.reference = TesseractTracker.getInstance(this.field_145850_b).add(this);
        }
        return this.reference;
    }

    public void invalidateReference() {
        this.reference = null;
    }

    public void channelChanged(EnumChannelType type) {
        LazyOptional<?> optional = this.capabilities.remove((Object)type);
        if (optional != null) {
            optional.invalidate();
        }
        this.notifyNeighbors();
    }

    public boolean renderOn() {
        return !this.isBlockedByRedstone();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return TesseractBlockEntity.computeIfLazyAbsent(this.capabilities, EnumChannelType.ITEMS, o -> {
                Channel channel = this.getChannel(EnumChannelType.ITEMS);
                return channel == null ? LazyOptional.empty() : LazyOptional.of(() -> channel.getItemHandler(this));
            }).cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return TesseractBlockEntity.computeIfLazyAbsent(this.capabilities, EnumChannelType.FLUID, o -> {
                Channel channel = this.getChannel(EnumChannelType.FLUID);
                return channel == null ? LazyOptional.empty() : LazyOptional.of(() -> channel.getFluidHandler(this));
            }).cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return TesseractBlockEntity.computeIfLazyAbsent(this.capabilities, EnumChannelType.ENERGY, o -> {
                Channel channel = this.getChannel(EnumChannelType.ENERGY);
                return channel == null ? LazyOptional.empty() : LazyOptional.of(() -> channel.getEnergyStorage(this));
            }).cast();
        }
        return super.getCapability(capability, side);
    }

    public <T> List<T> getSurroundingCapabilities(Capability<T> capability) {
        if (this.field_145850_b == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Direction facing : Direction.values()) {
            LazyOptional<?> optional = TesseractBlockEntity.computeIfLazyAbsent(this.surroundingCapabilities.get(facing), capability, o -> {
                TileEntity entity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (entity != null && !(entity instanceof TesseractBlockEntity)) {
                    return entity.getCapability(capability, facing.func_176734_d());
                }
                return LazyOptional.empty();
            });
            if (!optional.isPresent()) continue;
            list.add(optional.orElseGet(() -> null));
        }
        return list;
    }

    public boolean canSend(EnumChannelType type) {
        return this.transferState.get((Object)type).canSend() && !this.isBlockedByRedstone();
    }

    public boolean canReceive(EnumChannelType type) {
        return this.transferState.get((Object)type).canReceive() && !this.isBlockedByRedstone();
    }

    public boolean isBlockedByRedstone() {
        return this.redstoneState != RedstoneState.DISABLED && this.redstoneState == (this.redstone ? RedstoneState.LOW : RedstoneState.HIGH);
    }

    public int getChannelId(EnumChannelType type) {
        return this.getReference().getChannelId(type);
    }

    public TransferState getTransferState(EnumChannelType type) {
        return this.transferState.get((Object)type);
    }

    public void cycleTransferState(EnumChannelType type) {
        TransferState transferState = this.transferState.get((Object)type);
        this.transferState.put(type, transferState == TransferState.BOTH ? TransferState.SEND : (transferState == TransferState.SEND ? TransferState.RECEIVE : TransferState.BOTH));
        this.updateReference();
        this.dataChanged();
    }

    public RedstoneState getRedstoneState() {
        return this.redstoneState;
    }

    public void cycleRedstoneState() {
        this.redstoneState = this.redstoneState == RedstoneState.DISABLED ? RedstoneState.HIGH : (this.redstoneState == RedstoneState.HIGH ? RedstoneState.LOW : RedstoneState.DISABLED);
        this.updateReference();
        this.dataChanged();
    }

    public void setPowered(boolean powered) {
        if (this.redstone != powered) {
            this.redstone = powered;
            this.updateReference();
            this.dataChanged();
        }
    }

    private Channel getChannel(EnumChannelType type) {
        return this.getReference().getChannel(type);
    }

    public void onNeighborChanged(BlockPos neighbor) {
        Direction facing = Direction.func_176737_a((float)(neighbor.func_177958_n() - this.field_174879_c.func_177958_n()), (float)(neighbor.func_177956_o() - this.field_174879_c.func_177956_o()), (float)(neighbor.func_177952_p() - this.field_174879_c.func_177952_p()));
        this.surroundingCapabilities.get(facing).clear();
    }

    private void notifyNeighbors() {
        this.field_145850_b.func_230547_a_(this.field_174879_c, this.func_195044_w().func_177230_c());
    }

    private void updateReference() {
        TesseractReference reference = this.getReference();
        if (reference != null) {
            reference.update(this);
        }
    }

    protected CompoundNBT writeData() {
        CompoundNBT compound = new CompoundNBT();
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.func_74778_a("transferState" + type.name(), this.transferState.get((Object)type).name());
        }
        compound.func_74778_a("redstoneState", this.redstoneState.name());
        compound.func_74757_a("powered", this.redstone);
        return compound;
    }

    protected void readData(CompoundNBT compound) {
        for (EnumChannelType type : EnumChannelType.values()) {
            if (!compound.func_74764_b("transferState" + type.name())) continue;
            this.transferState.put(type, TransferState.valueOf(compound.func_74779_i("transferState" + type.name())));
        }
        if (compound.func_74764_b("redstoneState")) {
            this.redstoneState = RedstoneState.valueOf(compound.func_74779_i("redstoneState"));
        }
        if (compound.func_74764_b("powered")) {
            this.redstone = compound.func_74767_n("powered");
        }
    }

    public void onReplaced() {
        if (!this.field_145850_b.field_72995_K) {
            TesseractTracker.SERVER.remove(this.field_145850_b, this.field_174879_c);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.capabilities.values().forEach(LazyOptional::invalidate);
    }

    private static <K> LazyOptional<?> computeIfLazyAbsent(Map<K, LazyOptional<?>> map, K key, Function<? super K, ? extends LazyOptional<?>> mappingFunction) {
        if (!map.containsKey(key)) {
            return map.computeIfAbsent(key, mappingFunction);
        }
        LazyOptional<?> value = map.get(key);
        if (value == null) {
            return map.computeIfAbsent(key, mappingFunction);
        }
        if (value.isPresent()) {
            return value;
        }
        value = mappingFunction.apply(key);
        if (value != null) {
            map.put(key, value);
        }
        return value;
    }
}

