/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.worldgen;

import com.inventorypets.InventoryPets;
import com.inventorypets.config.InventoryPetsConfig;
import com.inventorypets.worldgen.WorldGen;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SeaCaveStructure
extends Structure<NoFeatureConfig> {
    private static final ResourceLocation PART = new ResourceLocation("inventorypets", "sea_cave");

    public SeaCaveStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.RAW_GENERATION;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, NoFeatureConfig config) {
        int i = chunkX >> 4;
        int j = chunkZ >> 4;
        rand.setSeed((long)(i ^ j << 4) ^ seed);
        rand.nextInt();
        return rand.nextDouble() < 0.25;
    }

    public String func_143025_a() {
        return new ResourceLocation("inventorypets", "sea_cave").toString();
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation loc;
        private Rotation rotation;

        public Piece(IStructurePieceType structurePieceTypeIn, CompoundNBT nbt) {
            super(structurePieceTypeIn, nbt);
            this.loc = new ResourceLocation(nbt.func_74779_i("template"));
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("rot"));
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            this(WorldGen.SEA_CAVE_PIECE, nbt);
            Template part = templateManager.func_200220_a(PART);
            PlacementSettings placement = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(part, this.field_186178_c, placement);
            this.field_186176_a = templateManager.func_200219_b(PART);
        }

        public Piece(TemplateManager templateManager, ResourceLocation template, BlockPos pos, Rotation rot, Random random) {
            super(WorldGen.SEA_CAVE_PIECE, 0);
            this.field_186178_c = pos.func_177979_c(0);
            this.rotation = rot;
            this.loc = template;
            Template part = templateManager.func_200220_a(PART);
            PlacementSettings placement = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(part, this.field_186178_c, placement);
            this.field_186176_a = templateManager.func_200219_b(PART);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("template", this.loc.toString());
            tagCompound.func_74778_a("rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager p_230383_2_, ChunkGenerator chunkGeneratorIn, Random rand, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn, BlockPos blockPosIn) {
            BlockPos spos = chunkPosIn.func_206849_h();
            BlockPos pos = new BlockPos(spos.func_177958_n() + 4, 55, spos.func_177952_p() + 4);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            Block chk1 = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_177230_c();
            Block chk3 = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1)).func_177230_c();
            Block chk4 = world.func_180495_p(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p() + 1)).func_177230_c();
            if (rand.nextBoolean()) {
                int i;
                int z1;
                int y1;
                int x1;
                --z;
                y -= 7;
                for (x1 = 0; x1 < 6; ++x1) {
                    for (y1 = 0; y1 < 5; ++y1) {
                        for (z1 = 0; z1 < 6; ++z1) {
                            world.func_180501_a(new BlockPos(x + x1, y + y1, z + z1), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                        }
                    }
                }
                for (i = 0; i < 5; ++i) {
                    world.func_180501_a(new BlockPos(x, y + i, z + 5), Blocks.field_150355_j.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 5, y + i, z + 5), Blocks.field_150355_j.func_176223_P(), 1);
                }
                for (i = 0; i < 6; ++i) {
                    world.func_180501_a(new BlockPos(x + i, y + 4, z + 5), Blocks.field_150355_j.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + i, y + 3, z + 5), Blocks.field_150355_j.func_176223_P(), 1);
                }
                world.func_180501_a(new BlockPos(x + 2, y + 1, z + 5), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 2, y + 2, z + 5), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 1, z + 5), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 2, z + 5), Blocks.field_150350_a.func_176223_P(), 1);
                for (x1 = 1; x1 < 5; ++x1) {
                    for (y1 = 1; y1 < 4; ++y1) {
                        for (z1 = 1; z1 < 4; ++z1) {
                            world.func_180501_a(new BlockPos(x + x1, y + y1, z + z1), Blocks.field_150350_a.func_176223_P(), 1);
                        }
                    }
                }
                world.func_180501_a(new BlockPos(x + 1, y + 1, z + 4), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 1, y + 2, z + 4), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 2, y + 1, z + 4), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 2, y + 2, z + 4), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 1, z + 4), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 2, z + 4), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 4, y + 1, z + 4), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 4, y + 2, z + 4), Blocks.field_150350_a.func_176223_P(), 1);
                for (i = 0; i < 5; ++i) {
                    world.func_180501_a(new BlockPos(x, y + 4, z + i), Blocks.field_150355_j.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 5, y + 4, z + i), Blocks.field_150355_j.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x, y + 3, z + i), Blocks.field_150355_j.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 5, y + 3, z + i), Blocks.field_150355_j.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 1, y + 4, z + i), Blocks.field_150355_j.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 4, y + 4, z + i), Blocks.field_150355_j.func_176223_P(), 1);
                }
                world.func_180501_a(new BlockPos(x + 2, y + 4, z + 4), Blocks.field_196619_M.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 4, z + 4), Blocks.field_150350_a.func_176223_P(), 1);
                for (i = 0; i < 5; ++i) {
                    world.func_180501_a(new BlockPos(x + 1, y + 3, z + i), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 4, y + 3, z + i), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                }
                if (InventoryPetsConfig.disableMobsSpawnInDungeons) {
                    world.func_180501_a(new BlockPos(x + 2, y, z + 4), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 3, y, z + 4), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                } else {
                    world.func_180501_a(new BlockPos(x + 2, y, z + 4), ((Block)InventoryPets.SAND_SPAWN.get()).func_176223_P(), 1);
                    world.func_205220_G_().func_205360_a(new BlockPos(x + 2, y, z + 4), (Object)InventoryPets.SAND_SPAWN.get(), 5);
                    world.func_180501_a(new BlockPos(x + 3, y, z + 4), ((Block)InventoryPets.SAND_SPAWN.get()).func_176223_P(), 1);
                    world.func_205220_G_().func_205360_a(new BlockPos(x + 3, y, z + 4), (Object)InventoryPets.SAND_SPAWN.get(), 5);
                }
                world.func_180501_a(new BlockPos(x + 2, y + 1, z + 1), Blocks.field_150486_ae.func_176223_P().func_185907_a(Rotation.CLOCKWISE_180), 1);
                ChestTileEntity tileentitychest = (ChestTileEntity)world.func_175625_s(new BlockPos(x + 2, y + 1, z + 1));
                this.addLewts(tileentitychest);
            } else if (chk3 == Blocks.field_150354_m && chk4 == Blocks.field_150354_m && chk1 == Blocks.field_150355_j) {
                int i;
                int z1;
                int y1;
                int x1;
                z -= 3;
                y -= 7;
                for (x1 = 0; x1 < 6; ++x1) {
                    for (y1 = 0; y1 < 5; ++y1) {
                        for (z1 = 0; z1 < 6; ++z1) {
                            world.func_180501_a(new BlockPos(x + x1, y + y1, z + z1), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                        }
                    }
                }
                for (i = 0; i < 5; ++i) {
                    world.func_180501_a(new BlockPos(x, y + i, z), Blocks.field_150350_a.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 5, y + i, z), Blocks.field_150350_a.func_176223_P(), 1);
                }
                for (i = 0; i < 6; ++i) {
                    world.func_180501_a(new BlockPos(x + i, y + 4, z), Blocks.field_150350_a.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + i, y + 3, z), Blocks.field_150350_a.func_176223_P(), 1);
                }
                world.func_180501_a(new BlockPos(x + 2, y + 1, z), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 2, y + 2, z), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 1, z), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 2, z), Blocks.field_150350_a.func_176223_P(), 1);
                for (x1 = 1; x1 < 5; ++x1) {
                    for (y1 = 1; y1 < 4; ++y1) {
                        for (z1 = 1; z1 < 4; ++z1) {
                            world.func_180501_a(new BlockPos(x + x1, y + y1, z + z1), Blocks.field_150350_a.func_176223_P(), 1);
                        }
                    }
                }
                world.func_180501_a(new BlockPos(x + 1, y + 1, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 1, y + 2, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 2, y + 1, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 2, y + 2, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 1, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 2, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 4, y + 1, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 4, y + 2, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                for (i = 0; i < 5; ++i) {
                    world.func_180501_a(new BlockPos(x, y + 4, z + i), Blocks.field_150350_a.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 5, y + 4, z + i), Blocks.field_150350_a.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x, y + 3, z + i), Blocks.field_150350_a.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 5, y + 3, z + i), Blocks.field_150350_a.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 1, y + 4, z + i), Blocks.field_150350_a.func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 4, y + 4, z + i), Blocks.field_150350_a.func_176223_P(), 1);
                }
                world.func_180501_a(new BlockPos(x + 2, y + 4, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 4, z + 1), Blocks.field_150350_a.func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 2, y + 3, z + 1), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 3, y + 3, z + 1), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                for (i = 0; i < 5; ++i) {
                    world.func_180501_a(new BlockPos(x + 1, y + 3, z + i), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 4, y + 3, z + i), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                }
                world.func_180501_a(new BlockPos(x + 1, y + 3, z), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                world.func_180501_a(new BlockPos(x + 4, y + 3, z), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                if (InventoryPetsConfig.disableMobsSpawnInDungeons) {
                    world.func_180501_a(new BlockPos(x + 2, y, z + 1), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                    world.func_180501_a(new BlockPos(x + 3, y, z + 1), ((Block)InventoryPets.SAND_BLOCK.get()).func_176223_P(), 1);
                } else {
                    world.func_180501_a(new BlockPos(x + 2, y, z + 1), ((Block)InventoryPets.SAND_SPAWN.get()).func_176223_P(), 1);
                    world.func_205220_G_().func_205360_a(new BlockPos(x + 2, y, z + 4), (Object)InventoryPets.SAND_SPAWN.get(), 5);
                    world.func_180501_a(new BlockPos(x + 3, y, z + 1), ((Block)InventoryPets.SAND_SPAWN.get()).func_176223_P(), 1);
                    world.func_205220_G_().func_205360_a(new BlockPos(x + 3, y, z + 4), (Object)InventoryPets.SAND_SPAWN.get(), 5);
                }
                world.func_180501_a(new BlockPos(x + 3, y + 1, z + 3), Blocks.field_150486_ae.func_176223_P().func_185907_a(Rotation.CLOCKWISE_180), 1);
                ChestTileEntity tileentitychest = (ChestTileEntity)world.func_175625_s(new BlockPos(x + 3, y + 1, z + 3));
                this.addLewts(tileentitychest);
            }
            return true;
        }

        public void addLewts(ChestTileEntity tileentitychest) {
            for (int g = 1; g < tileentitychest.func_70302_i_(); ++g) {
                int r;
                int h;
                Random rand = new Random();
                if (g == 4) {
                    for (int loopy = 0; loopy <= 50; ++loopy) {
                        int k;
                        h = rand.nextInt(100);
                        if (h >= 0 && h <= 19) {
                            k = rand.nextInt(8);
                            if (k == 0 && !InventoryPetsConfig.disableGhast) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_GHAST.get(), 1));
                                loopy = 50;
                            } else if (k == 1 && !InventoryPetsConfig.disableCreeper) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_CREEPER.get(), 1));
                                loopy = 50;
                            } else if (k == 2 && !InventoryPetsConfig.disableEnderman) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_ENDERMAN.get(), 1));
                                loopy = 50;
                            } else if (k == 3 && !InventoryPetsConfig.disableIronGolem) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_IRON_GOLEM.get(), 1));
                                loopy = 50;
                            } else if (k == 4 && !InventoryPetsConfig.disableSnowGolem) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_SNOW_GOLEM.get(), 1));
                                loopy = 50;
                            } else if (k == 5 && !InventoryPetsConfig.disableSpider) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_SPIDER.get(), 1));
                                loopy = 50;
                            } else if (k == 6 && !InventoryPetsConfig.disableMagmaCube) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_MAGMA_CUBE.get(), 1));
                                loopy = 50;
                            } else if (k == 7 && !InventoryPetsConfig.disableBlaze) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_BLAZE.get(), 1));
                                loopy = 50;
                            }
                        }
                        if (h >= 20 && h <= 49) {
                            k = rand.nextInt(7);
                            if (k == 0 && !InventoryPetsConfig.disableSheep) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_SHEEP.get(), 1));
                                loopy = 50;
                            } else if (k == 1 && !InventoryPetsConfig.disableCow) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_COW.get(), 1));
                                loopy = 50;
                            } else if (k == 2 && !InventoryPetsConfig.disableChicken) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_CHICKEN.get(), 1));
                                loopy = 50;
                            } else if (k == 3 && !InventoryPetsConfig.disablePig) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_PIG.get(), 1));
                                loopy = 50;
                            } else if (k == 4 && !InventoryPetsConfig.disableSquid) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_SQUID.get(), 1));
                                loopy = 50;
                            } else if (k == 5 && !InventoryPetsConfig.disableOcelot) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_OCELOT.get(), 1));
                                loopy = 50;
                            } else if (k == 6 && !InventoryPetsConfig.disableMooshroom) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_MOOSHROOM.get(), 1));
                                loopy = 50;
                            }
                        }
                        if (h >= 50 && h <= 74) {
                            k = rand.nextInt(13);
                            if (k == 0 && !InventoryPetsConfig.disableFurnace) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_FURNACE.get(), 1));
                                loopy = 50;
                            } else if (k == 1 && !InventoryPetsConfig.disableEnchantingTable) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_ENCHANTING_TABLE.get(), 1));
                                loopy = 50;
                            } else if (k == 2 && !InventoryPetsConfig.disableCraftingTable) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_CRAFTING_TABLE.get(), 1));
                                loopy = 50;
                            } else if (k == 3 && !InventoryPetsConfig.disableChest) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_CHEST_NEW, 1));
                                loopy = 50;
                            } else if (k == 4 && !InventoryPetsConfig.disableDoubleChest) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_DOUBLE_CHEST_NEW, 1));
                                loopy = 50;
                            } else if (k == 5 && !InventoryPetsConfig.disableBed) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_BED.get(), 1));
                                loopy = 50;
                            } else if (k == 6 && !InventoryPetsConfig.disableJukebox) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_JUKEBOX.get(), 1));
                                loopy = 50;
                            } else if (k == 7 && !InventoryPetsConfig.disableAnvil) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_ANVIL.get(), 1));
                                loopy = 50;
                            } else if (k == 8 && !InventoryPetsConfig.disableBrewingStand) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_BREWING_STAND.get(), 1));
                                loopy = 50;
                            } else if (k == 9 && !InventoryPetsConfig.disableNetherPortal) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_NETHER_PORTAL.get(), 1));
                                loopy = 50;
                            } else if (k == 10 && !InventoryPetsConfig.disableEnderChest) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_ENDER_CHEST.get(), 1));
                                loopy = 50;
                            } else if (k == 11 && !InventoryPetsConfig.disableSaddle) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_SADDLE.get(), 1));
                                loopy = 50;
                            } else if (k == 12 && !InventoryPetsConfig.disableLead) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_LEAD.get(), 1));
                                loopy = 50;
                            }
                        }
                        if (h >= 75 && h <= 79) {
                            k = rand.nextInt(11);
                            if (k == 0 && !InventoryPetsConfig.disablePingot) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_PINGOT.get(), 1));
                                loopy = 50;
                            } else if (k == 1 && !InventoryPetsConfig.disableMickerson) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_MICKERSON.get(), 1));
                                loopy = 50;
                            } else if (k == 2 && !InventoryPetsConfig.disablePurpliciousCow) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_PCOW.get(), 1));
                                loopy = 50;
                            } else if (k == 3 && !InventoryPetsConfig.disableQuantumCrystalMonster) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_QCM.get(), 1));
                                loopy = 50;
                            } else if (k == 4 && !InventoryPetsConfig.disableBanana) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_BANANA.get(), 1));
                                loopy = 50;
                            } else if (k == 5 && !InventoryPetsConfig.disableGrave) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_GRAVE.get(), 1));
                                loopy = 50;
                            } else if (k == 6 && !InventoryPetsConfig.disableQuiver) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_QUIVER.get(), 1));
                                loopy = 50;
                            } else if (k == 7 && !InventoryPetsConfig.disableSponge) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_SPONGE.get(), 1));
                                loopy = 50;
                            } else if (k == 8 && !InventoryPetsConfig.disableBiome) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_BIOME.get(), 1));
                                loopy = 50;
                            } else if (k == 9 && !InventoryPetsConfig.disableLoot) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_LOOT.get(), 1));
                                loopy = 50;
                            } else if (k == 10 && !InventoryPetsConfig.disableFlyingSaddle) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_FLYING_SADDLE.get(), 1));
                                loopy = 50;
                            }
                        }
                        if (h >= 80 && h <= 83) {
                            k = rand.nextInt(5);
                            if (k == 0 && !InventoryPetsConfig.disableJuggernaut) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_JUGGERNAUT.get(), 1));
                                loopy = 50;
                            } else if (k == 1 && !InventoryPetsConfig.disableIlluminati) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_ILLUMINATI.get(), 1));
                                loopy = 50;
                            } else if (k == 2 && !InventoryPetsConfig.disableSiamese) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_SIAMESE.get(), 1));
                                loopy = 50;
                            } else if (k == 3 && !InventoryPetsConfig.disableDirt) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_DIRT.get(), 1));
                                loopy = 50;
                            } else if (k == 4 && !InventoryPetsConfig.disableCobblestone) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_COBBLESTONE.get(), 1));
                                loopy = 50;
                            }
                        }
                        if (h >= 84 && h <= 92) {
                            k = rand.nextInt(8);
                            if (k == 0 && !InventoryPetsConfig.disablePacMan) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_PACMAN.get(), 1));
                                loopy = 50;
                            } else if (k == 1 && !InventoryPetsConfig.disableCheetah) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_CHEETAH.get(), 1));
                                loopy = 50;
                            } else if (k == 2 && !InventoryPetsConfig.disableHouse) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_HOUSE.get(), 1));
                                loopy = 50;
                            } else if (k == 3 && !InventoryPetsConfig.disableSiamese) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_SILVERFISH.get(), 1));
                                loopy = 50;
                            } else if (k == 4 && !InventoryPetsConfig.disableWolf) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_WOLF.get(), 1));
                                loopy = 50;
                            } else if (k == 5 && !InventoryPetsConfig.disableApple) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_APPLE.get(), 1));
                                loopy = 50;
                            } else if (k == 6 && !InventoryPetsConfig.disableTorch) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_TORCH.get(), 1));
                                loopy = 50;
                            } else if (k == 7 && !InventoryPetsConfig.disablePixie) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_PIXIE.get(), 1));
                                loopy = 50;
                            }
                        }
                        if (h >= 93 && h <= 98) {
                            k = rand.nextInt(4);
                            if (k == 0 && !InventoryPetsConfig.disableShield) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_SHIELD.get(), 1));
                                loopy = 50;
                            } else if (k == 1 && !InventoryPetsConfig.disableDubstep) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_DUBSTEP.get(), 1));
                                loopy = 50;
                            } else if (k == 2 && !InventoryPetsConfig.disableHeart) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_HEART.get(), 1));
                                loopy = 50;
                            } else if (k == 3 && !InventoryPetsConfig.disableMoon) {
                                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_MOON.get(), 1));
                                loopy = 50;
                            }
                        }
                        if (h < 99) continue;
                        tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.PET_PUFFERFISH.get(), 1));
                        loopy = 50;
                    }
                    continue;
                }
                if (g == 3 || g == 5) continue;
                int chance = rand.nextInt(100);
                h = rand.nextInt(67);
                if (chance <= 35) continue;
                if (h <= 49) {
                    if (h >= 0 && h <= 14) {
                        r = rand.nextInt(3) + 1;
                        tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Blocks.field_150360_v, r));
                    }
                    if (h >= 15 && h <= 30) {
                        r = 1;
                        tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_151131_as, r));
                    }
                    if (h >= 31 && h <= 43) {
                        r = rand.nextInt(4) + 1;
                        tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196086_aW, r));
                    }
                    if (h >= 44 && h <= 44) {
                        r = rand.nextInt(50);
                        if (r == 0) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196189_ec, 1));
                        } else if (r == 1) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196160_dU, 1));
                        } else if (r == 2) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196162_dV, 1));
                        } else if (r == 3) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196164_dW, 1));
                        } else if (r == 4) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196168_dY, 1));
                        } else if (r == 5) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196166_dX, 1));
                        } else if (r == 6) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196170_dZ, 1));
                        } else if (r == 7) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196187_ea, 1));
                        } else if (r == 8) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196190_ed, 1));
                        } else if (r == 9) {
                            tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196188_eb, 1));
                        }
                    }
                    if (h >= 45 && h <= 47) {
                        r = rand.nextInt(5) + 1;
                        tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_196128_bn, r));
                    }
                    if (h < 48 || h > 49) continue;
                    r = rand.nextInt(1) + 1;
                    tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_151045_i, r));
                    continue;
                }
                if (h >= 50 && h <= 50) {
                    r = rand.nextInt(4) + 1;
                    tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.NUGGET_EMERALD.get(), r));
                }
                if (h >= 51 && h <= 51) {
                    r = rand.nextInt(4) + 1;
                    tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.NUGGET_DIAMOND.get(), r));
                }
                if (h >= 52 && h <= 53) {
                    r = rand.nextInt(4) + 1;
                    tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.NUGGET_ENDER.get(), r));
                }
                if (h >= 54 && h <= 57) {
                    r = rand.nextInt(4) + 1;
                    tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.NUGGET_LAPIS.get(), r));
                }
                if (h >= 58 && h <= 61) {
                    r = rand.nextInt(4) + 1;
                    tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)InventoryPets.NUGGET_OBSIDIAN.get(), r));
                }
                if (h < 62 || h > 66) continue;
                r = rand.nextInt(4) + 1;
                tileentitychest.func_70299_a(g, new ItemStack((IItemProvider)Items.field_191525_da, r));
            }
        }
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> config, int chunkX, int chunkZ, MutableBoundingBox bounds, int refs, long seed) {
            super(config, chunkX, chunkZ, bounds, refs, seed);
        }

        public void func_230364_a_(DynamicRegistries registries, ChunkGenerator generator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            if (InventoryPetsConfig.disableAllDungeons || InventoryPetsConfig.disableSeaCaveDungeons) {
                return;
            }
            int freq = InventoryPetsConfig.frequencySeaCaveDungeons;
            freq = 100 - freq * 10 - 25;
            if (this.field_214631_d.nextInt(100) < freq) {
                return;
            }
            int i = chunkX * 16 + this.field_214631_d.nextInt(16);
            int j = chunkZ * 16 + this.field_214631_d.nextInt(16);
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            this.field_75075_a.add(new Piece(templateManager, PART, new BlockPos(i, 55, j), rotation, (Random)this.field_214631_d));
            this.func_202500_a();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void func_230366_a_(ISeedReader worldIn, StructureManager p_230366_2_, ChunkGenerator p_230366_3_, Random p_230366_4_, MutableBoundingBox p_230366_5_, ChunkPos p_230366_6_) {
            List list = this.field_75075_a;
            synchronized (list) {
                if (!this.field_75075_a.isEmpty()) {
                    MutableBoundingBox mutableboundingbox = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215127_b(10, 4, 10);
                    Vector3i vector3i = mutableboundingbox.func_215126_f();
                    BlockPos blockpos = new BlockPos(vector3i.func_177958_n(), mutableboundingbox.field_78895_b, vector3i.func_177952_p());
                    Iterator iterator = this.field_75075_a.iterator();
                    while (iterator.hasNext()) {
                        StructurePiece structurepiece = (StructurePiece)iterator.next();
                        if (!structurepiece.func_230383_a_(worldIn, p_230366_2_, p_230366_3_, p_230366_4_, p_230366_5_, p_230366_6_, blockpos)) continue;
                        iterator.remove();
                    }
                    this.func_202500_a();
                }
            }
        }

        protected void func_202500_a() {
            this.field_75074_b = MutableBoundingBox.func_78887_a().func_215127_b(10, 4, 10);
            for (StructurePiece structurepiece : this.field_75075_a) {
                this.field_75074_b.func_78888_b(structurepiece.func_74874_b());
            }
        }
    }
}

