/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.screens;

import com.inventorypets.config.InventoryPetsConfig;
import com.inventorypets.networking.PacketBiomeFinder;
import com.inventorypets.networking.PacketHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeFinderScreen
extends Screen {
    private static final int WIDTH = 179;
    private static final int HEIGHT = 151;
    private static String title = I18n.func_135052_a((String)"gui.biometofind", (Object[])new Object[0]);
    private static final ResourceLocation GUI = new ResourceLocation("inventorypets:textures/gui/container/pet_namer.png");
    private String searchBiome;
    private ItemStack currentItem;
    private String s;
    private int biomeNum;
    private int biomeLen;
    private String[] biomes2 = new String[2000];
    protected ITextComponent cancelText;
    protected ITextComponent acceptText;
    protected ITextComponent leftText;
    protected ITextComponent rightText;

    public BiomeFinderScreen(PlayerInventory inventoryplayer) {
        super((ITextComponent)new StringTextComponent(title));
        if (inventoryplayer.func_70448_g().func_77942_o()) {
            this.searchBiome = inventoryplayer.func_70448_g().func_77978_p().func_74779_i("biometofind");
        }
        this.currentItem = inventoryplayer.func_70448_g();
        this.cancelText = new TranslationTextComponent("gui.cancel");
        this.acceptText = new TranslationTextComponent("gui.accept");
        this.leftText = new StringTextComponent("<");
        this.rightText = new StringTextComponent(">");
    }

    protected void func_231160_c_() {
        int i;
        int relX = (this.field_230708_k_ - 179) / 2;
        int relY = (this.field_230709_l_ - 151) / 2;
        int chunkNo = InventoryPetsConfig.biomePetChunks;
        Object[] biomes = new String[chunkNo * 2 * chunkNo * 2];
        int biomeX = 0;
        int biomeZ = 0;
        int biomeCounter = 0;
        ClientPlayerEntity entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
        for (int x = -chunkNo; x < chunkNo; ++x) {
            for (int z = -chunkNo; z < chunkNo; ++z) {
                biomeX = (int)entityPlayerSP.field_70142_S + x * 16;
                biomeZ = (int)entityPlayerSP.field_70136_U + z * 16;
                biomes[biomeCounter] = entityPlayerSP.field_70170_p.func_226691_t_(new BlockPos(biomeX, 0, biomeZ)).func_201856_r().func_222352_a() + "|" + biomeX + "|" + biomeZ;
                ++biomeCounter;
            }
        }
        Arrays.sort(biomes);
        String[] temp = new String[biomes.length];
        this.biomeLen = 0;
        int biomeEnd = 0;
        int biomeEnd2 = 0;
        for (i = 0; i < biomes.length - 1; ++i) {
            biomeEnd = ((String)biomes[i]).indexOf("|");
            biomeEnd2 = ((String)biomes[i + 1]).indexOf("|");
            String biomeCurrent = ((String)biomes[i]).substring(0, biomeEnd).trim();
            String biomeNext = ((String)biomes[i + 1]).substring(0, biomeEnd2).trim();
            if (biomeCurrent == "" || biomeNext == "" || biomeCurrent.toLowerCase().contains("coniferous forest") || biomeCurrent.equals(biomeNext)) continue;
            temp[this.biomeLen++] = biomes[i];
        }
        temp[this.biomeLen++] = biomes[biomes.length - 1];
        for (i = 0; i < this.biomeLen; ++i) {
            biomes[i] = temp[i];
            this.biomes2[i] = temp[i];
        }
        this.searchBiome = biomes[this.biomeNum];
        int sepLoc = this.searchBiome.indexOf("|");
        this.searchBiome = this.searchBiome.substring(0, sepLoc).trim();
        if (this.searchBiome.length() > 20) {
            this.searchBiome = this.searchBiome.substring(0, 20);
            this.searchBiome = this.searchBiome + ".";
        }
        this.func_230480_a_((Widget)new Button(relX + 10, relY + 72, 72, 20, this.cancelText, button -> this.close()));
        this.func_230480_a_((Widget)new Button(relX + 94, relY + 72, 72, 20, this.acceptText, button -> this.searchForBiome()));
        this.func_230480_a_((Widget)new Button(relX + 10, relY + 44, 14, 20, this.leftText, button -> this.navLeft()));
        this.func_230480_a_((Widget)new Button(relX + 152, relY + 44, 14, 20, this.rightText, button -> this.navRight()));
        this.func_230480_a_((Widget)new Button(relX + 30, relY + 44, 116, 20, (ITextComponent)new StringTextComponent(this.searchBiome), button -> this.searchForBiome()));
    }

    public boolean func_231177_au__() {
        return false;
    }

    public String func_231167_h_() {
        return I18n.func_135052_a((String)"gui.biometofind", (Object[])new Object[0]);
    }

    private void close() {
        this.field_230706_i_.func_147108_a(null);
    }

    private void navLeft() {
        Button chk = (Button)this.field_230710_m_.get(4);
        if (this.biomeNum - 1 >= 0) {
            String tempName = this.biomes2[this.biomeNum - 1];
            int sepLoc = tempName.indexOf("|");
            if ((tempName = tempName.substring(0, sepLoc).trim()).length() > 20) {
                tempName = tempName.substring(0, 20);
                tempName = tempName + ".";
            }
            chk.func_238482_a_((ITextComponent)new StringTextComponent(tempName));
            --this.biomeNum;
            return;
        }
        String tempName = this.biomes2[this.biomeLen - 1];
        int sepLoc = tempName.indexOf("|");
        if ((tempName = tempName.substring(0, sepLoc).trim()).length() > 20) {
            tempName = tempName.substring(0, 20);
            tempName = tempName + ".";
        }
        chk.func_238482_a_((ITextComponent)new StringTextComponent(tempName));
        this.biomeNum = this.biomeLen - 1;
    }

    private void navRight() {
        Button chk = (Button)this.field_230710_m_.get(4);
        if (this.biomeNum + 1 < this.biomeLen) {
            String tempName = this.biomes2[this.biomeNum + 1];
            int sepLoc = tempName.indexOf("|");
            if ((tempName = tempName.substring(0, sepLoc).trim()).length() > 20) {
                tempName = tempName.substring(0, 20);
                tempName = tempName + ".";
            }
            chk.func_238482_a_((ITextComponent)new StringTextComponent(tempName));
            ++this.biomeNum;
            return;
        }
        String tempName = this.biomes2[0];
        int sepLoc = tempName.indexOf("|");
        if ((tempName = tempName.substring(0, sepLoc).trim()).length() > 20) {
            tempName = tempName.substring(0, 20);
            tempName = tempName + ".";
        }
        chk.func_238482_a_((ITextComponent)new StringTextComponent(tempName));
        this.biomeNum = 0;
    }

    private void searchForBiome() {
        ItemStack getPet2 = this.currentItem;
        this.s = this.biomes2[this.biomeNum];
        if (!getPet2.func_77942_o()) {
            getPet2.func_77982_d(new CompoundNBT());
        }
        getPet2.func_77978_p().func_74778_a("biometofind", this.s);
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        PacketHandler.sendToServer(clientPlayer, new PacketBiomeFinder(this.s));
        int biomeX = 0;
        int biomeZ = 0;
        String biomeString = this.s;
        int sepLoc = this.s.indexOf("|");
        String biome = sepLoc >= 0 ? biomeString.substring(0, sepLoc).trim() : "";
        String biomeCoords = biomeString.substring(sepLoc + 1, biomeString.length());
        sepLoc = biomeCoords.indexOf("|");
        if (sepLoc >= 0) {
            biomeX = Integer.parseInt(biomeCoords.substring(0, sepLoc).trim());
            biomeZ = Integer.parseInt(biomeCoords.substring(sepLoc + 1, biomeCoords.length()).trim());
            double diffX = Math.abs((double)biomeX - clientPlayer.func_226277_ct_());
            double diffZ = Math.abs((double)biomeZ - clientPlayer.func_226281_cx_());
            int dist = (int)Math.sqrt(diffX * diffX + diffZ * diffZ);
            clientPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("Found \u00a7l" + biome + "\u00a7r, about " + dist + " blocks in this direction."), true);
            BiomeFinderScreen.LookAt(biomeX, clientPlayer.field_70137_T, biomeZ, (PlayerEntity)clientPlayer);
        }
        this.field_230706_i_.func_147108_a(null);
    }

    public static void LookAt(double px, double py, double pz, PlayerEntity me) {
        double dirx = me.field_70142_S - px;
        double diry = me.field_70137_T - py;
        double dirz = me.field_70136_U - pz;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        me.field_70125_A = (float)pitch;
        me.field_70177_z = (float)(yaw += 90.0);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI);
        int relX = (this.field_230708_k_ - 179) / 2;
        int relY = (this.field_230709_l_ - 151) / 2;
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, 179, 151);
        BiomeFinderScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)title, (int)(this.field_230708_k_ / 2 - 80), (int)(relY + 10), (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

