/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.networking;

import com.inventorypets.networking.PacketBiomeFinder;
import com.inventorypets.networking.PacketDisableCheck;
import com.inventorypets.networking.PacketKeyInput;
import com.inventorypets.networking.PacketPetNamer;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    private static SimpleChannel networkWrapper;
    private static final String PROTOCOL = "1";

    private PacketHandler() {
    }

    public static void init() {
        networkWrapper = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("inventorypets", "channel"), () -> PROTOCOL, PROTOCOL::equals, PROTOCOL::equals);
        int idx = 0;
        networkWrapper.registerMessage(idx++, PacketKeyInput.class, PacketKeyInput::encode, PacketKeyInput::decode, PacketKeyInput::onMessage);
        networkWrapper.registerMessage(idx++, PacketPetNamer.class, PacketPetNamer::encode, PacketPetNamer::decode, PacketPetNamer::onMessage);
        networkWrapper.registerMessage(idx++, PacketBiomeFinder.class, PacketBiomeFinder::encode, PacketBiomeFinder::decode, PacketBiomeFinder::onMessage);
        networkWrapper.registerMessage(idx, PacketDisableCheck.class, PacketDisableCheck::encode, PacketDisableCheck::decode, PacketDisableCheck::onMessage);
    }

    public static <M> void sendToClient(ServerPlayerEntity player, M message) {
        networkWrapper.sendTo(message, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <M> void sendToServer(ClientPlayerEntity player, M message) {
        networkWrapper.sendToServer(message);
    }

    public static <M> void sendToAllAround(M message, PacketDistributor.TargetPoint targetPoint) {
        networkWrapper.send(PacketDistributor.NEAR.with(() -> targetPoint), message);
    }
}

