/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.networking;

import com.inventorypets.config.InventoryPetsConfig;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDisableCheck {
    private final boolean disableSpider;

    public PacketDisableCheck(boolean disableSpider) {
        this.disableSpider = disableSpider;
    }

    static void encode(PacketDisableCheck msg, PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(msg.disableSpider);
    }

    static PacketDisableCheck decode(PacketBuffer packetBuffer) {
        return new PacketDisableCheck(packetBuffer.readBoolean());
    }

    static void onMessage(PacketDisableCheck msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketDisableCheck.handleMessage(msg, ((NetworkEvent.Context)contextSupplier.get()).getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(PacketDisableCheck msg, ServerPlayerEntity sender) {
        boolean disableSpider;
        InventoryPetsConfig.disableSpider = disableSpider = msg.disableSpider;
    }
}

