/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.inventorypets.InventoryPets;
import com.inventorypets.helper.ProxyHelper;
import com.inventorypets.init.ModSoundEvents;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class MiniQuantumEndermanEntity
extends MonsterEntity {
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Optional<BlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(MiniQuantumEndermanEntity.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(MiniQuantumEndermanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_226535_bx_ = EntityDataManager.func_187226_a(MiniQuantumEndermanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int field_226536_bz_ = Integer.MIN_VALUE;
    private int teleportDelay;
    private boolean isAggressive;
    private int miniCount = 1800;
    private int targetChangeTime;

    public MiniQuantumEndermanEntity(EntityType<? extends MiniQuantumEndermanEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new FindPlayerGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (entitylivingbaseIn == null) {
            this.targetChangeTime = 0;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)false);
            this.field_70180_af.func_187227_b(field_226535_bx_, (Object)false);
            modifiableattributeinstance.func_111124_b(ATTACKING_SPEED_BOOST);
        } else {
            this.targetChangeTime = this.field_70173_aa;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)true);
            if (!modifiableattributeinstance.func_180374_a(ATTACKING_SPEED_BOOST)) {
                modifiableattributeinstance.func_233767_b_(ATTACKING_SPEED_BOOST);
            }
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, Optional.empty());
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
        this.field_70180_af.func_187214_a(field_226535_bx_, (Object)false);
    }

    public void func_226539_l_() {
        if (this.field_70173_aa >= this.field_226536_bz_ + 400) {
            this.field_226536_bz_ = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.func_226537_et_() && this.field_70170_p.field_72995_K) {
            this.func_226539_l_();
        }
        super.func_184206_a(key);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        BlockState blockstate = this.getHeldBlockState();
        if (blockstate != null) {
            compound.func_218657_a("carriedBlockState", (INBT)NBTUtil.func_190009_a((BlockState)blockstate));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        BlockState blockstate = null;
        if (compound.func_150297_b("carriedBlockState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("carriedBlockState"))).func_177230_c() == Blocks.field_150350_a) {
            blockstate = null;
        }
        this.func_195406_b(blockstate);
    }

    private boolean shouldAttackPlayer(PlayerEntity player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            return false;
        }
        Vector3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vector3d vec3d1 = new Vector3d(this.func_226277_ct_() - player.func_226277_ct_(), this.func_226280_cw_() - player.func_226280_cw_(), this.func_226281_cx_() - player.func_226281_cx_());
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)this) : false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.55f;
    }

    public void func_70636_d() {
        PlayerEntity entityplayer = this.field_70170_p.func_217362_a((Entity)this, 100.0);
        if (entityplayer != null) {
            if (Math.abs(entityplayer.field_70142_S - this.field_70142_S) + Math.abs(entityplayer.field_70137_T - this.field_70137_T) + Math.abs(entityplayer.field_70136_U - this.field_70136_U) >= 48.0) {
                this.func_213293_j(entityplayer.field_70142_S - this.field_70142_S, entityplayer.field_70137_T - this.field_70137_T, entityplayer.field_70136_U - this.field_70136_U);
            }
            if (entityplayer.func_110144_aD() != null && entityplayer.func_110144_aD().func_70089_S()) {
                this.func_70624_b(entityplayer.func_110144_aD());
            } else {
                this.func_70624_b(entityplayer.func_110144_aD());
            }
        } else {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            ProxyHelper.spawnPortalEffects2(this.field_70170_p, (int)this.field_70142_S, (int)this.field_70137_T, (int)this.field_70136_U);
        }
        if (this.func_70026_G() || this.func_70027_ad()) {
            this.func_70624_b(null);
            this.isAggressive = false;
        }
        if (!this.isScreaming() || this.isAggressive || this.field_70146_Z.nextInt(100) == 0) {
            // empty if block
        }
        this.field_70703_bu = false;
        if (this.func_70638_az() != null) {
            this.func_70625_a((Entity)this.func_70638_az(), 100.0f, 100.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.func_70638_az() != null) {
                if (this.func_70638_az() instanceof LivingEntity) {
                    this.teleportDelay = 0;
                } else if (this.func_70638_az().func_70068_e((Entity)this) > 256.0 && this.teleportDelay++ >= 60 && this.teleportToEntity((Entity)this.func_70638_az())) {
                    this.teleportDelay = 0;
                }
            } else {
                this.teleportDelay = 0;
            }
        }
        --this.miniCount;
        if (this.miniCount <= 0) {
            this.field_70170_p.func_184148_a(null, this.field_70142_S, this.field_70137_T, this.field_70136_U, ModSoundEvents.mqedeath, SoundCategory.HOSTILE, 0.8f, 1.0f);
            this.func_70106_y();
        }
        if (this.func_70638_az() == entityplayer) {
            this.func_70624_b(null);
        }
        super.func_70636_d();
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vector3d vec3d = new Vector3d(this.field_70142_S - p_70816_1_.field_70142_S, this.func_174813_aQ().field_72338_b + (double)(this.func_213302_cg() / 2.0f) - p_70816_1_.field_70137_T + (double)p_70816_1_.func_70047_e(), this.field_70136_U - p_70816_1_.field_70136_U);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70142_S + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * d0;
        double d2 = this.field_70137_T + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * d0;
        double d3 = this.field_70136_U + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return ModSoundEvents.mqeidle;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSoundEvents.mqehit;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.mqedeath;
    }

    protected Item getDropItem() {
        return (Item)InventoryPets.NUGGET_ENDER.get();
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.func_199702_a((IItemProvider)InventoryPets.NUGGET_ENDER.get(), 1);
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        BlockState blockstate = this.getHeldBlockState();
        if (blockstate != null) {
            this.func_199703_a((IItemProvider)blockstate.func_177230_c());
        }
    }

    public void func_195406_b(@Nullable BlockState p_195406_1_) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, Optional.ofNullable(p_195406_1_));
    }

    @Nullable
    public BlockState getHeldBlockState() {
        return ((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orElse(null);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !this.func_180431_b(source);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    public boolean func_226537_et_() {
        return (Boolean)this.field_70180_af.func_187225_a(field_226535_bx_);
    }

    public void func_226538_eu_() {
        this.field_70180_af.func_187227_b(field_226535_bx_, (Object)true);
    }

    public boolean func_230270_dK_() {
        return true;
    }

    protected void func_70619_bc() {
        float f;
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.targetChangeTime + 600 && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_226660_f_(this.func_233580_cy_()) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
        }
        super.func_70619_bc();
    }

    static class StareGoal
    extends Goal {
        private final MiniQuantumEndermanEntity enderman;
        private LivingEntity targetPlayer;

        public StareGoal(MiniQuantumEndermanEntity endermanIn) {
            this.enderman = endermanIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.targetPlayer = this.enderman.func_70638_az();
            if (!(this.targetPlayer instanceof PlayerEntity)) {
                return false;
            }
            double d0 = this.targetPlayer.func_70068_e((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.shouldAttackPlayer((PlayerEntity)this.targetPlayer);
        }

        public void func_75249_e() {
            this.enderman.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.enderman.func_70671_ap().func_220679_a(this.targetPlayer.func_226277_ct_(), this.targetPlayer.func_226280_cw_(), this.targetPlayer.func_226281_cx_());
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final MiniQuantumEndermanEntity enderman;
        private PlayerEntity player;
        private int aggroTime;
        private int teleportTime;
        private final EntityPredicate field_220791_m;
        private final EntityPredicate field_220792_n = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(MiniQuantumEndermanEntity p_i45842_1_) {
            super((MobEntity)p_i45842_1_, PlayerEntity.class, false);
            this.enderman = p_i45842_1_;
            this.field_220791_m = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> p_i45842_1_.shouldAttackPlayer((PlayerEntity)p_220790_1_));
        }

        public boolean func_75250_a() {
            this.player = this.enderman.field_70170_p.func_217370_a(this.field_220791_m, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.func_226538_eu_();
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.enderman.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.enderman.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.field_220792_n.func_221015_a((LivingEntity)this.enderman, this.field_75309_a) ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.enderman.func_184218_aH()) {
                    if (this.enderman.shouldAttackPlayer((PlayerEntity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportToEntity((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

