/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.inventorypets.InventoryPets;
import com.inventorypets.capabilities.DataProvider;
import com.inventorypets.init.ModSoundEvents;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class BananaEntity
extends ThrowableEntity
implements IRendersAsItem {
    private int soundDelay = 0;

    public BananaEntity(EntityType<? extends BananaEntity> appleEntity, World worldIn) {
        super(appleEntity, worldIn);
    }

    public BananaEntity(World world, PlayerEntity player) {
        super((EntityType)InventoryPets.BANANA_ENTITY.get(), (LivingEntity)player, world);
    }

    public BananaEntity(World world, double x, double y, double z) {
        super((EntityType)InventoryPets.BANANA_ENTITY.get(), x, y, z, world);
    }

    protected float func_70185_h() {
        return 0.02f;
    }

    protected Item getDefaultItem() {
        return (Item)InventoryPets.BANANA.get();
    }

    protected void func_70227_a(RayTraceResult result) {
        --this.soundDelay;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            int i = entity instanceof GhastEntity ? 24 : 12;
            entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), (float)i);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
            }
        }
        if (!(this.field_70170_p.field_72995_K || this.soundDelay >= 1 || result.func_216346_c() != RayTraceResult.Type.BLOCK && result.func_216346_c() != RayTraceResult.Type.ENTITY)) {
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), ModSoundEvents.splat, SoundCategory.NEUTRAL, 0.6f, this.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.5f);
            this.soundDelay = 10;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            PlayerEntity entityplayer = (PlayerEntity)this.func_234616_v_();
            if (entityplayer != null && !entityplayer.func_184812_l_()) {
                entityplayer.getCapability(DataProvider.CAPS).ifPresent(props -> {
                    boolean offFlag = false;
                    int slot = props.getSlot();
                    if (slot == -100) {
                        offFlag = true;
                    }
                    int dmg = props.getDamage();
                    String name = props.getName();
                    ItemStack itemstack = new ItemStack((IItemProvider)InventoryPets.PET_BANANA.get(), 1);
                    itemstack.func_196085_b(dmg);
                    itemstack.func_200302_a((ITextComponent)new StringTextComponent(name));
                    if (offFlag) {
                        entityplayer.func_184611_a(Hand.OFF_HAND, itemstack);
                    } else if (entityplayer.field_71071_by.func_70301_a(slot) == null) {
                        entityplayer.field_71071_by.func_70299_a(slot, itemstack);
                    } else if (entityplayer.field_71071_by.func_70301_a(slot).func_77973_b() == Blocks.field_150350_a.func_199767_j() || entityplayer.field_71071_by.func_70301_a(slot).func_77973_b() == InventoryPets.PET_BANANA.get()) {
                        entityplayer.field_71071_by.func_70299_a(slot, itemstack);
                    } else {
                        int slot2 = entityplayer.field_71071_by.func_70447_i();
                        if (slot2 != -1) {
                            entityplayer.field_71071_by.func_70299_a(slot2, itemstack);
                        } else {
                            ItemEntity entityitem2 = new ItemEntity(entityplayer.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), itemstack);
                            this.field_70170_p.func_217376_c((Entity)entityitem2);
                        }
                    }
                });
            }
        }
        this.spawnParticles();
    }

    protected void func_70088_a() {
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)InventoryPets.BANANA.get());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void spawnParticles() {
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        ItemParticleData itemParticleData = new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)InventoryPets.BANANA.get(), 1));
        for (int particleNum = 0; particleNum < 4; ++particleNum) {
            this.field_70170_p.func_195594_a((IParticleData)itemParticleData, x, y, z, this.field_70146_Z.nextGaussian() * 0.1, this.field_70146_Z.nextDouble() * 0.2, this.field_70146_Z.nextGaussian() * 0.11);
        }
    }
}

