/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.container;

import com.inventorypets.handler.ItemStackHandlerDoubleChest;
import com.inventorypets.init.ModRegistry;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerDoubleChest
extends Container {
    private final ItemStackHandlerDoubleChest ItemStackHandlerDoubleChest;
    private final ItemStack itemStackBeingHeld;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int MAX_EXPECTED_SLOT_COUNT = 54;
    public static final int INVENTORY_YPOS = 18;
    public static final int PLAYER_INVENTORY_YPOS = 140;
    private static final Logger LOGGER = LogManager.getLogger();

    public static ContainerDoubleChest createContainerServerSide(int windowID, PlayerInventory playerInventory, ItemStackHandlerDoubleChest chestContents, ItemStack itemDoubleChest) {
        return new ContainerDoubleChest(windowID, playerInventory, chestContents, itemDoubleChest);
    }

    public static ContainerDoubleChest createContainerClientSide(int windowID, PlayerInventory playerInventory, PacketBuffer extraData) {
        int numberOfSlots = extraData.readInt();
        try {
            ItemStackHandlerDoubleChest ItemStackHandlerDoubleChest2 = new ItemStackHandlerDoubleChest(numberOfSlots);
            return new ContainerDoubleChest(windowID, playerInventory, ItemStackHandlerDoubleChest2, ItemStack.field_190927_a);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn((Object)iae);
            return null;
        }
    }

    public ContainerDoubleChest(int windowId, PlayerInventory playerInv, ItemStackHandlerDoubleChest ItemStackHandlerDoubleChest2, ItemStack itemStackBeingHeld) {
        super(ModRegistry.containerTypeDoubleChest, windowId);
        this.ItemStackHandlerDoubleChest = ItemStackHandlerDoubleChest2;
        this.itemStackBeingHeld = itemStackBeingHeld;
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 198;
        for (int x = 0; x < 9; ++x) {
            int slotNumber = x;
            this.func_75146_a(new Slot((IInventory)playerInv, slotNumber, 8 + 18 * x, 198));
        }
        int PLAYER_INVENTORY_XPOS = 8;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 140 + y * 18;
                this.func_75146_a(new Slot((IInventory)playerInv, slotNumber, xpos, ypos));
            }
        }
        int chestSlotCount = ItemStackHandlerDoubleChest2.getSlots();
        if (chestSlotCount < 1 || chestSlotCount > 54) {
            LOGGER.warn("Unexpected invalid slot count in ItemStackHandlerDoubleChest(" + chestSlotCount + ")");
            chestSlotCount = MathHelper.func_76125_a((int)chestSlotCount, (int)1, (int)54);
        }
        int SLOTS_PER_ROW = 9;
        int INVENTORY_XPOS = 8;
        for (int chestSlot = 0; chestSlot < chestSlotCount; ++chestSlot) {
            int slotNumber = chestSlot;
            int chestRow = chestSlot / 9;
            int chestCol = chestSlot % 9;
            int xpos = 8 + 18 * chestCol;
            int ypos = 18 + 18 * chestRow;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)ItemStackHandlerDoubleChest2, slotNumber, xpos, ypos));
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        return !main.func_190926_b() && main == this.itemStackBeingHeld || !off.func_190926_b() && off == this.itemStackBeingHeld;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        int SLOT_COUNT = this.ItemStackHandlerDoubleChest.getSlots();
        if (sourceSlotIndex >= 0 && sourceSlotIndex < 36) {
            if (!this.func_75135_a(sourceStack, 36, 36 + SLOT_COUNT, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (sourceSlotIndex >= 36 && sourceSlotIndex < 36 + SLOT_COUNT) {
            if (!this.func_75135_a(sourceStack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            LOGGER.warn("Invalid slotIndex:" + sourceSlotIndex);
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190916_E() == 0) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_190901_a(player, sourceStack);
        return copyOfSourceStack;
    }

    public void func_75142_b() {
        if (this.ItemStackHandlerDoubleChest.isDirty()) {
            CompoundNBT nbt = this.itemStackBeingHeld.func_196082_o();
            int dirtyCounter = nbt.func_74762_e("dirtyCounter");
            nbt.func_74768_a("dirtyCounter", dirtyCounter + 1);
            this.itemStackBeingHeld.func_77982_d(nbt);
        }
        super.func_75142_b();
    }
}

