/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.crafting.TagMapper;
import com.blakebr0.cucumber.crafting.recipe.ShapedNoMirrorRecipe;
import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedTagRecipe
extends ShapedNoMirrorRecipe {
    public ShapedTagRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> inputs, ItemStack output) {
        super(id, group, width, height, inputs, output);
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.CRAFTING_SHAPED_TAG;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedTagRecipe> {
        public ShapedTagRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map map = ShapedRecipe.func_192408_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.func_194134_a((String[])ShapedRecipe.func_192407_a((JsonArray)JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList ingredients = ShapedRecipe.func_192402_a((String[])pattern, (Map)map, (int)width, (int)height);
            JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
            String tag = JSONUtils.func_151200_h((JsonObject)result, (String)"tag");
            int count = JSONUtils.func_151208_a((JsonObject)result, (String)"count", (int)1);
            Item item = TagMapper.getItemForTag(tag);
            if (item == Items.field_190931_a) {
                return null;
            }
            ItemStack output = new ItemStack((IItemProvider)item, count);
            return new ShapedTagRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public ShapedTagRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int width = buffer.func_150792_a();
            int height = buffer.func_150792_a();
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            return new ShapedTagRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public void toNetwork(PacketBuffer buffer, ShapedTagRecipe recipe) {
            buffer.func_150787_b(recipe.func_192403_f());
            buffer.func_150787_b(recipe.func_192404_g());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

