/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.registry.Registries;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BaseBlock
extends Block {
    private static final ITag.INamedTag<Block> MINEABLE_WITH_AXE = BlockTags.func_199894_a((String)"mineable/axe");
    private static final ITag.INamedTag<Block> MINEABLE_WITH_HOE = BlockTags.func_199894_a((String)"mineable/hoe");
    private static final ITag.INamedTag<Block> MINEABLE_WITH_PICKAXE = BlockTags.func_199894_a((String)"mineable/pickaxe");
    private static final ITag.INamedTag<Block> MINEABLE_WITH_SHOVEL = BlockTags.func_199894_a((String)"mineable/shovel");
    private static final ITag.INamedTag<Block> NEEDS_DIAMOND_TOOL = BlockTags.func_199894_a((String)"needs_diamond_tool");
    private static final ITag.INamedTag<Block> NEEDS_IRON_TOOL = BlockTags.func_199894_a((String)"needs_iron_tool");
    private static final ITag.INamedTag<Block> NEEDS_STONE_TOOL = BlockTags.func_199894_a((String)"needs_stone_tool");
    private final boolean saveTileData;

    public BaseBlock(boolean saveTileData, AbstractBlock.Properties properties) {
        super(properties);
        this.saveTileData = saveTileData;
    }

    public BaseBlock(boolean saveTileData, BlockProperties properties) {
        this(saveTileData, properties.toUnderlying());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!this.saveTileData) {
            return;
        }
        CompoundNBT tag = stack.func_77978_p();
        CompoundNBT compoundNBT = tag == null ? null : (tag = tag.func_74764_b("tileData") ? tag.func_74775_l("tileData") : null);
        if (tag == null || tag.isEmpty()) {
            return;
        }
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof BaseBlockEntity) {
            ((BaseBlockEntity)entity).readData(tag);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List items = super.func_220076_a(state, builder);
        if (!this.saveTileData) {
            return items;
        }
        TileEntity entity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (!(entity instanceof BaseBlockEntity)) {
            return items;
        }
        CompoundNBT entityTag = ((BaseBlockEntity)entity).writeItemStackData();
        if (entityTag == null || entityTag.isEmpty()) {
            return items;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("tileData", (INBT)entityTag);
        for (ItemStack stack : items) {
            if (!(stack.func_77973_b() instanceof BlockItem) || ((BlockItem)stack.func_77973_b()).func_179223_d() != this) continue;
            stack.func_77982_d(tag);
        }
        return items;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (!this.saveTileData) {
            return stack;
        }
        TileEntity entity = world.func_175625_s(pos);
        if (!(entity instanceof BaseBlockEntity)) {
            return stack;
        }
        CompoundNBT entityTag = ((BaseBlockEntity)entity).writeItemStackData();
        if (entityTag == null || entityTag.isEmpty()) {
            return stack;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("tileData", (INBT)entityTag);
        if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() == this) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        return this.interact(state, level, pos, player, hand, hitResult.func_216354_b(), hitResult.func_216347_e()).interactionResult;
    }

    protected InteractionFeedback interact(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, Direction hitSide, Vector3d hitLocation) {
        return InteractionFeedback.PASS;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> information, ITooltipFlag flag) {
        this.appendItemInformation(stack, level, information::add, flag.func_194127_a());
        super.func_190948_a(stack, level, information, flag);
    }

    protected void appendItemInformation(ItemStack stack, @Nullable IBlockReader level, Consumer<ITextComponent> info, boolean advanced) {
    }

    public Item func_199767_j() {
        return super.func_199767_j();
    }

    public String func_149739_a() {
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier(this);
        return identifier.func_110624_b() + ".block." + identifier.func_110623_a();
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.AXE && this.func_203417_a((ITag)MINEABLE_WITH_AXE) || tool == ToolType.HOE && this.func_203417_a((ITag)MINEABLE_WITH_HOE) || tool == ToolType.PICKAXE && this.func_203417_a((ITag)MINEABLE_WITH_PICKAXE) || tool == ToolType.SHOVEL && this.func_203417_a((ITag)MINEABLE_WITH_SHOVEL);
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.func_203417_a((ITag)MINEABLE_WITH_AXE) ? ToolType.AXE : (this.func_203417_a((ITag)MINEABLE_WITH_HOE) ? ToolType.HOE : (this.func_203417_a((ITag)MINEABLE_WITH_PICKAXE) ? ToolType.PICKAXE : (this.func_203417_a((ITag)MINEABLE_WITH_SHOVEL) ? ToolType.SHOVEL : null)));
    }

    public int getHarvestLevel(BlockState state) {
        return this.func_203417_a((ITag)NEEDS_DIAMOND_TOOL) ? 3 : (this.func_203417_a((ITag)NEEDS_IRON_TOOL) ? 2 : (this.func_203417_a((ITag)NEEDS_STONE_TOOL) ? 1 : -1));
    }

    protected static enum InteractionFeedback {
        PASS(ActionResultType.PASS),
        CONSUME(ActionResultType.CONSUME),
        SUCCESS(ActionResultType.SUCCESS);

        private final ActionResultType interactionResult;

        private InteractionFeedback(ActionResultType interactionResult) {
            this.interactionResult = interactionResult;
        }
    }
}

