/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TextComponents {
    public static TextComponentBuilder empty() {
        return TextComponents.string("");
    }

    public static TextComponentBuilder string(String text) {
        return new TextComponentBuilder((IFormattableTextComponent)new StringTextComponent(text));
    }

    public static TextComponentBuilder number(int number) {
        return new TextComponentBuilder((IFormattableTextComponent)new StringTextComponent(Integer.toString(number)));
    }

    public static TextComponentBuilder number(double number, int decimals) {
        return new TextComponentBuilder((IFormattableTextComponent)new StringTextComponent(String.format("%." + decimals + "f", number)));
    }

    public static TextComponentBuilder number(double number) {
        return new TextComponentBuilder((IFormattableTextComponent)new StringTextComponent(Double.toString(number)));
    }

    public static TextComponentBuilder translation(String translationKey, Object ... arguments) {
        return new TextComponentBuilder((IFormattableTextComponent)new TranslationTextComponent(translationKey, arguments));
    }

    public static TextComponentBuilder translation(String translationKey) {
        return new TextComponentBuilder((IFormattableTextComponent)new TranslationTextComponent(translationKey));
    }

    public static TextComponentBuilder fromTextComponent(IFormattableTextComponent textComponent) {
        return new TextComponentBuilder(textComponent);
    }

    public static TextComponentBuilder fromTextComponent(ITextComponent textComponent) {
        return TextComponents.fromTextComponent(textComponent.func_230531_f_());
    }

    public static String format(ITextComponent textComponent) {
        return textComponent.getString();
    }

    public static TextComponentBuilder block(Block block) {
        return TextComponents.translation(block.func_149739_a());
    }

    public static TextComponentBuilder blockState(BlockState state) {
        return TextComponents.block(state.func_177230_c());
    }

    public static TextComponentBuilder item(Item item) {
        return TextComponents.translation(item.func_77658_a());
    }

    public static TextComponentBuilder itemStack(ItemStack stack) {
        return TextComponents.fromTextComponent(stack.func_200301_q().func_230531_f_());
    }

    public static TextComponentBuilder fluid(Fluid fluid) {
        return TextComponents.translation(fluid.getAttributes().getTranslationKey());
    }

    public static TextComponentBuilder fluidStack(FluidStack stack) {
        return TextComponents.fromTextComponent(stack.getDisplayName().func_230531_f_());
    }

    public static TextComponentBuilder entity(Entity entity) {
        return TextComponents.fromTextComponent(entity.func_145818_k_() ? entity.func_200201_e() : entity.func_145748_c_());
    }

    public static TextComponentBuilder dimension(RegistryKey<World> dimension) {
        String dimensionName = dimension.func_240901_a_().func_110623_a();
        dimensionName = dimensionName.substring(Math.min(dimensionName.length() - 1, Math.max(0, dimensionName.indexOf(47) + 1))).toLowerCase();
        dimensionName = dimensionName.substring(0, 1).toUpperCase() + dimensionName.substring(1);
        for (int i = 0; i < dimensionName.length() - 1; ++i) {
            if (dimensionName.charAt(i) != '_' || !Character.isAlphabetic(dimensionName.charAt(i + 1))) continue;
            dimensionName = dimensionName.substring(0, i) + ' ' + (i + 2 < dimensionName.length() ? dimensionName.substring(i + 1, i + 2).toUpperCase() + dimensionName.substring(i + 2) : dimensionName.substring(i + 1).toUpperCase());
        }
        return TextComponents.string(dimensionName);
    }

    public static TextComponentBuilder dimension(World world) {
        return TextComponents.dimension((RegistryKey<World>)world.func_234923_W_());
    }

    public static class TextComponentBuilder {
        private final TextComponentBuilder parent;
        private final IFormattableTextComponent textComponent;

        private TextComponentBuilder(IFormattableTextComponent textComponent, TextComponentBuilder parent) {
            this.textComponent = textComponent;
            this.parent = parent;
        }

        private TextComponentBuilder(IFormattableTextComponent textComponent) {
            this(textComponent, (TextComponentBuilder)null);
        }

        public TextComponentBuilder formatting(TextFormatting color) {
            this.updateStyle(style -> style.func_240712_a_(color));
            return this;
        }

        public TextComponentBuilder color(TextFormatting color) {
            return this.formatting(color);
        }

        public TextComponentBuilder bold() {
            this.updateStyle(style -> style.func_240713_a_(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder italic() {
            this.updateStyle(style -> style.func_240722_b_(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder underline() {
            this.updateStyle(style -> style.setUnderlined(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder strikethrough() {
            this.updateStyle(style -> style.setStrikethrough(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder obfuscate() {
            this.updateStyle(style -> style.setObfuscated(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder reset() {
            this.updateStyle(style -> Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240722_b_(Boolean.valueOf(false)).setUnderlined(Boolean.valueOf(false)).setStrikethrough(Boolean.valueOf(false)).setObfuscated(Boolean.valueOf(false)));
            return this;
        }

        private void updateStyle(Function<Style, Style> updater) {
            this.textComponent.func_230530_a_(updater.apply(this.textComponent.func_150256_b()));
        }

        public TextComponentBuilder string(String text) {
            return this.append((IFormattableTextComponent)new StringTextComponent(text));
        }

        public TextComponentBuilder translation(String translationKey, Object ... arguments) {
            return this.append((IFormattableTextComponent)new TranslationTextComponent(translationKey, arguments));
        }

        public TextComponentBuilder translation(String translationKey) {
            return this.append((IFormattableTextComponent)new TranslationTextComponent(translationKey));
        }

        public TextComponentBuilder append(IFormattableTextComponent textComponent) {
            this.textComponent.func_230529_a_((ITextComponent)textComponent);
            return new TextComponentBuilder(textComponent, this);
        }

        public IFormattableTextComponent get() {
            return this.parent == null ? this.textComponent : this.parent.get();
        }

        public String format() {
            return TextComponents.format((ITextComponent)this.get());
        }
    }
}

