/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.initialinventory;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.initialinventory.InitialInventory;
import com.blamejared.initialinventory.InventoryItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.entity.player.PlayerEntity;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.initialinventory.InvHandler")
@ZenRegister
public class InvHandler {
    @ZenCodeType.Method
    public static void addStartingItem(String key, IItemStack item, @ZenCodeType.OptionalInt(value=-1) int slotId, @ZenCodeType.Optional(value="(stack as crafttweaker.api.item.IItemStack, player as crafttweaker.api.player.MCPlayerEntity) as crafttweaker.api.item.IItemStack => stack") BiFunction<IItemStack, PlayerEntity, IItemStack> onGiven) {
        CraftTweakerAPI.apply((IAction)new AddItem(new InventoryItem(key, item, slotId, onGiven)));
    }

    private static class AddItem
    implements IUndoableAction {
        private final InventoryItem item;

        public AddItem(InventoryItem item) {
            this.item = item;
        }

        public void apply() {
            List list = InitialInventory.STACK_MAP.computeIfAbsent(this.item.getKey(), s -> new ArrayList());
            list.add(this.item);
        }

        public String describe() {
            return String.format("Adding starting item: %s in slot: %s in key: %s", this.item.getStack().getCommandString(), this.item.getIndex(), this.item.getKey());
        }

        public void undo() {
            List list = InitialInventory.STACK_MAP.computeIfAbsent(this.item.getKey(), s -> new ArrayList());
            list.removeIf(itemStackIntegerPair -> itemStackIntegerPair.getStack().matches(this.item.getStack()));
        }

        public String describeUndo() {
            return String.format("Removing starting item: %s in slot: %s in key: %s", this.item.getStack().getCommandString(), this.item.getIndex(), this.item.getKey());
        }
    }
}

