/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class RemapHandler {
    private static final Map<String, ResourceLocation> itemReMap = new HashMap<String, ResourceLocation>();
    private static final Map<String, ResourceLocation> fullReMap = new HashMap<String, ResourceLocation>();

    @SubscribeEvent
    public static void onRemapBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            if (!fullReMap.containsKey(mapping.key.func_110623_a())) continue;
            try {
                Supplementaries.LOGGER.warn("Remapping block '{}' to '{}'", (Object)mapping.key, (Object)fullReMap.get(mapping.key.func_110623_a()));
                mapping.remap(ForgeRegistries.BLOCKS.getValue(fullReMap.get(mapping.key.func_110623_a())));
            }
            catch (Throwable t) {
                Supplementaries.LOGGER.warn("Remapping block '{}' to '{}' failed: {}", (Object)mapping.key, (Object)fullReMap.get(mapping.key.func_110623_a()), (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void onRemapTiles(RegistryEvent.MissingMappings<TileEntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            if (!fullReMap.containsKey(mapping.key.func_110623_a())) continue;
            try {
                Supplementaries.LOGGER.warn("Remapping tile entity '{}' to '{}'", (Object)mapping.key, (Object)fullReMap.get(mapping.key.func_110623_a()));
                mapping.remap(ForgeRegistries.TILE_ENTITIES.getValue(fullReMap.get(mapping.key.func_110623_a())));
            }
            catch (Throwable t) {
                Supplementaries.LOGGER.warn("Remapping  tile entity '{}' to '{}' failed: {}", (Object)mapping.key, (Object)fullReMap.get(mapping.key.func_110623_a()), (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void onRemapItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            if (!itemReMap.containsKey(mapping.key.func_110623_a())) continue;
            try {
                Supplementaries.LOGGER.warn("Remapping item '{}' to '{}'", (Object)mapping.key, (Object)itemReMap.get(mapping.key.func_110623_a()));
                mapping.remap(ForgeRegistries.ITEMS.getValue(itemReMap.get(mapping.key.func_110623_a())));
            }
            catch (Throwable t) {
                Supplementaries.LOGGER.warn("Remapping item '{}' to '{}' failed: {}", (Object)mapping.key, (Object)itemReMap.get(mapping.key.func_110623_a()), (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void onRemapEntityTypes(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            if (!fullReMap.containsKey(mapping.key.func_110623_a())) continue;
            try {
                Supplementaries.LOGGER.warn("Remapping entity '{}' to '{}'", (Object)mapping.key, (Object)fullReMap.get(mapping.key.func_110623_a()));
                mapping.remap(ForgeRegistries.ENTITIES.getValue(fullReMap.get(mapping.key.func_110623_a())));
            }
            catch (Throwable t) {
                Supplementaries.LOGGER.warn("Remapping entity '{}' to '{}' failed: {}", (Object)mapping.key, (Object)fullReMap.get(mapping.key.func_110623_a()), (Object)t);
            }
        }
    }

    static {
        fullReMap.put("orange_trader", ModRegistry.RED_MERCHANT_TYPE.getId());
        fullReMap.put("piston_launcher", ModRegistry.SPRING_LAUNCHER.getId());
        fullReMap.put("piston_launcher_arm", ModRegistry.SPRING_LAUNCHER_ARM.getId());
        fullReMap.put("piston_launcher_head", ModRegistry.SPRING_LAUNCHER_HEAD.getId());
        itemReMap.put("jar_full", ModRegistry.JAR_ITEM.getId());
        itemReMap.put("jar_full_tinted", ModRegistry.JAR_ITEM_TINTED.getId());
        itemReMap.put("cage_full", ModRegistry.CAGE_ITEM.getId());
        itemReMap.put("wall_lantern", Items.field_222111_pQ.getRegistryName());
        itemReMap.put("stick", Items.field_151055_y.getRegistryName());
        itemReMap.put("blaze_rod", Items.field_151072_bj.getRegistryName());
        itemReMap.put("hanging_flower_pot", Items.field_222087_nH.getRegistryName());
        itemReMap.put("gunpowder", Items.field_151016_H.getRegistryName());
        for (RegistryObject<Block> banner : ModRegistry.CEILING_BANNERS.values()) {
            itemReMap.put(banner.getId().func_110623_a(), new ResourceLocation("minecraft", banner.getId().func_110623_a().replace("ceiling_banner_", "") + "_banner"));
        }
        itemReMap.put("directional_cake", Items.field_222070_lD.getRegistryName());
        itemReMap.putAll(fullReMap);
    }
}

