/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class StaticBlockItem {
    @Nullable
    public static BlockState getPlacementState(BlockItemUseContext context, Block block2) {
        BlockState blockstate = block2.func_196258_a(context);
        return blockstate != null && StaticBlockItem.canPlace(context, blockstate) ? blockstate : null;
    }

    public static boolean canPlace(BlockItemUseContext context, BlockState state) {
        PlayerEntity playerentity = context.func_195999_j();
        ISelectionContext iselectioncontext = playerentity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)playerentity);
        return state.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) && context.func_195991_k().func_226663_a_(state, context.func_195995_a(), iselectioncontext);
    }

    private static BlockState updateBlockStateFromTag(BlockPos pos, World world, ItemStack stack, BlockState state) {
        BlockState blockstate = state;
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("BlockStateTag");
            StateContainer statecontainer = state.func_177230_c().func_176194_O();
            for (String s : compoundnbt1.func_150296_c()) {
                Property property = statecontainer.func_185920_a(s);
                if (property == null) continue;
                String s1 = compoundnbt1.func_74781_a(s).func_150285_a_();
                blockstate = StaticBlockItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != state) {
            world.func_180501_a(pos, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> tProperty, String name) {
        return tProperty.func_185929_b(name).map(p -> (BlockState)state.func_206870_a(tProperty, p)).orElse(state);
    }

    private static SoundEvent getPlaceSound(BlockState state, World world, BlockPos pos, PlayerEntity entity2) {
        return state.getSoundType((IWorldReader)world, pos, (Entity)entity2).func_185841_e();
    }

    public static ActionResultType place(BlockItemUseContext context, Block blockToPlace) {
        if (!context.func_196011_b() || context == null) {
            return ActionResultType.FAIL;
        }
        BlockState blockstate = StaticBlockItem.getPlacementState(context, blockToPlace);
        if (blockstate == null) {
            return ActionResultType.FAIL;
        }
        if (!context.func_195991_k().func_180501_a(context.func_195995_a(), blockstate, 11)) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        PlayerEntity playerentity = context.func_195999_j();
        ItemStack itemstack = context.func_195996_i();
        BlockState placedState = world.func_180495_p(blockpos);
        Block block2 = placedState.func_177230_c();
        if (block2 == blockstate.func_177230_c()) {
            placedState = StaticBlockItem.updateBlockStateFromTag(blockpos, world, itemstack, placedState);
            BlockItem.func_179224_a((World)world, (PlayerEntity)playerentity, (BlockPos)blockpos, (ItemStack)itemstack);
            block2.func_180633_a(world, blockpos, placedState, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = placedState.getSoundType((IWorldReader)world, blockpos, (Entity)context.func_195999_j());
        world.func_184133_a(playerentity, blockpos, StaticBlockItem.getPlaceSound(placedState, world, blockpos, context.func_195999_j()), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (playerentity == null || !playerentity.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }
}

