/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import net.mehvahdjukaar.supplementaries.common.VectorUtils;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RotationTrailParticle
extends SimpleAnimatedParticle {
    public static final float SPEED = 11.0f;
    public static final int LIFE = 8;
    private final Vector3d axis;
    private final Vector3d origin;
    private final double radius;
    private float angularVelocity;
    private float currentAngle;
    private float fadeR;
    private float fadeG;
    private float fadeB;
    private static final float al = 0.6f;

    private RotationTrailParticle(ClientWorld clientWorld, double x, double y, double z, Vector3d center, Vector3d rotationAxis, int ccw, double radius, double angle, IAnimatedSprite sprite) {
        super(clientWorld, x, y, z, sprite, -5.0E-4f);
        this.origin = center;
        this.axis = rotationAxis;
        this.angularVelocity = (float)((double)((float)ccw * 11.0f) * Math.PI / 180.0);
        this.radius = radius;
        this.currentAngle = (float)angle;
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.func_187115_a(0.01f, 0.01f);
        this.field_70544_f *= 0.625f;
        this.field_70547_e = 8;
        this.func_187146_c(2783210);
        this.func_187145_d(3325690);
        this.func_217566_b(sprite);
        this.field_82339_as = 0.6f;
        this.field_190017_n = false;
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.func_82338_g(0.6f - (float)this.field_70546_d / (float)this.field_70547_e * 0.6f * 0.7f);
    }

    public void func_187145_d(int pRgb) {
        this.fadeR = (float)((pRgb & 0xFF0000) >> 16) / 255.0f;
        this.fadeG = (float)((pRgb & 0xFF00) >> 8) / 255.0f;
        this.fadeB = (float)(pRgb & 0xFF) / 255.0f;
        super.func_187145_d(pRgb);
    }

    public void func_187110_a(double x, double y, double z) {
        this.field_70552_h += (this.fadeR - this.field_70552_h) * 0.1f;
        this.field_70553_i += (this.fadeG - this.field_70553_i) * 0.1f;
        this.field_70551_j += (this.fadeB - this.field_70551_j) * 0.1f;
        this.currentAngle += this.angularVelocity;
        Vector3d rot = new Vector3d(this.radius, 0.0, 0.0).func_178785_b(this.currentAngle);
        Vector3d newPos = VectorUtils.changeBasisN(this.axis, rot).func_178787_e(this.origin);
        this.angularVelocity = (float)((double)this.angularVelocity * 0.75);
        super.func_187110_a(newPos.field_72450_a - this.field_187126_f, newPos.field_72448_b - this.field_187127_g, newPos.field_72449_c - this.field_187128_h);
    }

    public static float increment(float age, int step) {
        return 11.0f * (float)step * (1.0f - ((float)step + 2.0f * (age - 1.0f)) / 16.0f);
    }

    public int func_189214_a(float pPartialTick) {
        BlockPos blockpos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        return this.field_187122_b.func_175667_e(blockpos) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)this.field_187122_b, (BlockPos)blockpos) : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite sprites;

        public Factory(IAnimatedSprite spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(BasicParticleType type, ClientWorld world, double centerX, double centerY, double centerZ, double direction, double radius, double initialAngle) {
            Vector3d center = new Vector3d(centerX, centerY, centerZ);
            int ccw = 1;
            if (direction < 0.0) {
                ccw = -1;
                direction = -direction;
            }
            Direction dir = Direction.func_82600_a((int)((int)direction));
            float radAngle = (float)(initialAngle * Math.PI / 180.0);
            Vector3d axis = VectorUtils.ItoD(dir.func_176730_m());
            Vector3d rot = new Vector3d(radius, 0.0, 0.0).func_178785_b(radAngle);
            Vector3d newPos = VectorUtils.changeBasisN(axis, rot).func_178787_e(center);
            return new RotationTrailParticle(world, newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c, center, axis, ccw, radius, radAngle, this.sprites);
        }
    }
}

