/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.Locale;
import java.util.UUID;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.StatueBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.Credits;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class StatueBlockTile
extends ItemDisplayTile {
    @Nullable
    public GameProfile owner = null;
    private StatuePose pose = StatuePose.STANDING;
    private boolean isWaving = false;
    private BlockState candle = null;

    public StatueBlockTile() {
        super((TileEntityType)ModRegistry.STATUE_TILE.get());
    }

    public void func_213903_a(ITextComponent name) {
        super.func_213903_a(name);
        this.updateName();
    }

    public StatuePose getPose() {
        return this.pose;
    }

    public boolean isWaving() {
        return this.isWaving;
    }

    public BlockState hasCandle() {
        return this.candle;
    }

    public void setOwner(@Nullable GameProfile input) {
        if (this.owner == null) {
            this.owner = input;
            this.owner = SkullTileEntity.func_174884_b((GameProfile)this.owner);
            this.func_70296_d();
        }
    }

    private void updateName() {
        if (this.func_145818_k_()) {
            String name = this.func_200201_e().getString().toLowerCase(Locale.ROOT);
            Pair<UUID, String> profile = Credits.INSTANCE.statues().get(name);
            if (profile != null) {
                this.setOwner(new GameProfile((UUID)profile.getFirst(), (String)profile.getSecond()));
            }
        } else {
            this.owner = null;
        }
    }

    public void updateClientVisualsOnLoad() {
        this.updateName();
        ItemStack stack = this.getDisplayedItem();
        this.pose = StatuePose.getPose(stack);
        this.isWaving = (Boolean)this.func_195044_w().func_177229_b((Property)StatueBlock.POWERED);
    }

    public void updateTileOnInventoryChanged() {
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.statuette");
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)NoticeBoardBlock.FACING);
    }

    public static enum StatuePose {
        STANDING,
        HOLDING,
        CANDLE,
        SWORD,
        TOOL,
        GLOBE,
        SEPIA_GLOBE;


        public static StatuePose getPose(ItemStack stack) {
            if (stack.func_190926_b()) {
                return STANDING;
            }
            Item i = stack.func_77973_b();
            if (CommonUtil.isSword(i)) {
                return SWORD;
            }
            if (CommonUtil.isTool(i)) {
                return TOOL;
            }
            if (i == ModRegistry.GLOBE_ITEM.get()) {
                return GLOBE;
            }
            return HOLDING;
        }

        public boolean isGlobe() {
            return this == GLOBE || this == SEPIA_GLOBE;
        }
    }
}

