/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.IResetUseOnDamage;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.container.WaystoneSelectionContainer;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class WarpStoneItem
extends Item
implements IResetUseOnDamage {
    public static final String name = "warp_stone";
    public static final ResourceLocation registryName = new ResourceLocation("waystones", "warp_stone");
    private static final INamedContainerProvider containerProvider = new INamedContainerProvider(){

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.waystones.waystone_selection");
        }

        public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return WaystoneSelectionContainer.createWaystoneSelection(i, playerEntity, WarpMode.WARP_STONE, null);
        }
    };

    public WarpStoneItem() {
        super(new Item.Properties().func_200916_a(Waystones.itemGroup).func_200917_a(1).func_200918_c(100));
    }

    public int func_77626_a(ItemStack itemStack) {
        return (Integer)WaystonesConfig.SERVER.warpStoneUseTime.get();
    }

    public UseAction func_77661_b(ItemStack itemStack) {
        if (Waystones.proxy.isVivecraftInstalled()) {
            return UseAction.NONE;
        }
        return UseAction.BOW;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity entityLiving) {
        if (!world.field_72995_K && entityLiving instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)entityLiving), (INamedContainerProvider)containerProvider, it -> it.writeByte(WarpMode.WARP_STONE.ordinal()));
        }
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.field_71075_bZ.field_75098_d) {
            PlayerWaystoneManager.setWarpStoneCooldownUntil(player, 0L);
        }
        if (PlayerWaystoneManager.canUseWarpStone(player, itemStack)) {
            if (!player.func_184587_cr() && world.field_72995_K) {
                Waystones.proxy.playSound(SoundEvents.field_187814_ei, new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()), 2.0f);
            }
            if (Waystones.proxy.isVivecraftInstalled()) {
                this.func_77654_b(itemStack, world, (LivingEntity)player);
            } else {
                player.func_184598_c(hand);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
        }
        TranslationTextComponent chatComponent = new TranslationTextComponent("chat.waystones.warpstone_not_charged");
        chatComponent.func_240699_a_(TextFormatting.RED);
        player.func_146105_b((ITextComponent)chatComponent, true);
        return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return this.getDurabilityForDisplay(itemStack) > 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return 0.0;
        }
        long timeLeft = PlayerWaystoneManager.getWarpStoneCooldownLeft((PlayerEntity)player);
        long maxCooldown = (Integer)WaystonesConfig.SERVER.warpStoneCooldown.get() * 20;
        if (maxCooldown == 0L) {
            return 0.0;
        }
        return MathHelper.func_76131_a((float)((float)timeLeft / (float)maxCooldown), (float)0.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return PlayerWaystoneManager.canUseWarpStone((PlayerEntity)Minecraft.func_71410_x().field_71439_g, itemStack) || super.func_77636_d(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        long timeLeft = PlayerWaystoneManager.getWarpStoneCooldownLeft((PlayerEntity)player);
        int secondsLeft = (int)(timeLeft / 20L);
        if (secondsLeft > 0) {
            TranslationTextComponent secondsLeftText = new TranslationTextComponent("tooltip.waystones.cooldown_left", new Object[]{secondsLeft});
            secondsLeftText.func_240699_a_(TextFormatting.GOLD);
            tooltip.add((ITextComponent)secondsLeftText);
        }
    }
}

