/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.KnownWaystonesMessage;
import net.blay09.mods.waystones.network.message.PlayerWaystoneCooldownsMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class WaystoneSyncManager {
    public static void sendWaystoneUpdateToAll(IWaystone waystone) {
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (ServerPlayerEntity player : players) {
            WaystoneSyncManager.sendWaystoneUpdate((PlayerEntity)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((PlayerEntity)player);
        }
    }

    public static void sendActivatedWaystones(PlayerEntity player) {
        List<IWaystone> waystones = PlayerWaystoneManager.getWaystones(player);
        NetworkHandler.sendTo(new KnownWaystonesMessage(WaystoneTypes.WAYSTONE, waystones), player);
    }

    public static void sendWarpPlates(PlayerEntity player) {
        List<IWaystone> warpPlates = WaystoneManager.get().getWaystonesByType(WaystoneTypes.WARP_PLATE).collect(Collectors.toList());
        NetworkHandler.sendTo(new KnownWaystonesMessage(WaystoneTypes.WARP_PLATE, warpPlates), player);
    }

    public static void sendWaystoneUpdate(PlayerEntity player, IWaystone waystone) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            NetworkHandler.sendTo(new KnownWaystonesMessage(waystone.getWaystoneType(), Collections.singletonList(waystone)), player);
        }
    }

    public static void sendWaystoneCooldowns(PlayerEntity player) {
        long inventoryButtonCooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        long warpStoneCooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        NetworkHandler.sendTo(new PlayerWaystoneCooldownsMessage(inventoryButtonCooldownUntil, warpStoneCooldownUntil), player);
    }
}

