/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TileMap<TileType extends TileEntity> {
    private Vector3i scratchVector = new Vector3i();
    private final LinkedHashMap<Vector3ic, TileEntity[][][]> internalMap = new LinkedHashMap();
    private int size = 0;

    public boolean addTile(TileType tile) {
        TileEntity[] XYsubSection;
        BlockPos tilePos = tile.func_174877_v();
        this.scratchVector.set(tilePos.func_177958_n() >> 4, tilePos.func_177956_o() >> 4, tilePos.func_177952_p() >> 4);
        TileEntity[][][] sectionArray = this.internalMap.computeIfAbsent(this.scratchVector, k -> {
            this.scratchVector = new Vector3i((Vector3ic)k);
            return new TileEntity[16][][];
        });
        TileEntity[][] XsubSection = sectionArray[tilePos.func_177958_n() & 0xF];
        if (XsubSection == null) {
            XsubSection = new TileEntity[16][];
            sectionArray[tilePos.func_177958_n() & 0xF] = XsubSection;
        }
        if ((XYsubSection = XsubSection[tilePos.func_177956_o() & 0xF]) == null) {
            XYsubSection = new TileEntity[16];
            XsubSection[tilePos.func_177956_o() & 0xF] = XYsubSection;
        }
        TileEntity prevVal = XYsubSection[tilePos.func_177952_p() & 0xF];
        XYsubSection[tilePos.func_177952_p() & 0xF] = tile;
        if (prevVal == null) {
            ++this.size;
            return true;
        }
        return false;
    }

    public void addAll(TileMap<TileType> otherMap) {
        otherMap.forEachTile(this::addTile);
    }

    public boolean removeTile(TileType tile) {
        BlockPos tilePos = tile.func_174877_v();
        this.scratchVector.set(tilePos.func_177958_n() >> 4, tilePos.func_177956_o() >> 4, tilePos.func_177952_p() >> 4);
        TileEntity[][][] sectionArray = this.internalMap.get(this.scratchVector);
        if (sectionArray == null) {
            return false;
        }
        TileEntity[][] XsubSection = sectionArray[tilePos.func_177958_n() & 0xF];
        if (XsubSection == null) {
            return false;
        }
        TileEntity[] XYsubSection = XsubSection[tilePos.func_177956_o() & 0xF];
        if (XYsubSection == null) {
            return false;
        }
        TileEntity prevVal = XYsubSection[tilePos.func_177952_p() & 0xF];
        XYsubSection[tilePos.func_177952_p() & 0xF] = null;
        if (prevVal != null) {
            --this.size;
        }
        for (TileEntity tileEntity : XYsubSection) {
            if (tileEntity == null) continue;
            return prevVal != null;
        }
        XsubSection[tilePos.func_177956_o() & 0xF] = null;
        for (TileEntity tileEntity : XsubSection) {
            if (tileEntity == null) continue;
            return prevVal != null;
        }
        sectionArray[tilePos.func_177958_n() & 0xF] = null;
        for (TileEntity tileEntity : sectionArray) {
            if (tileEntity == null) continue;
            return prevVal != null;
        }
        this.internalMap.remove(this.scratchVector);
        return prevVal != null;
    }

    public boolean containsTile(TileType tile) {
        return this.containsPos(tile.func_174877_v());
    }

    public boolean containsPos(BlockPos pos) {
        return this.getTile(pos) != null;
    }

    public boolean containsPos(Vector3i pos) {
        return this.getTile(pos) != null;
    }

    @Nullable
    public TileType getTile(Vector3ic pos) {
        int x = pos.x();
        int y = pos.y();
        int z = pos.z();
        this.scratchVector.set(pos.x() >> 4, pos.y() >> 4, pos.z() >> 4);
        TileEntity[][][] sectionArray = this.internalMap.get(this.scratchVector);
        if (sectionArray == null) {
            return null;
        }
        TileEntity[][] XsubSection = sectionArray[x & 0xF];
        if (XsubSection == null) {
            return null;
        }
        TileEntity[] XYsubSection = XsubSection[y & 0xF];
        if (XYsubSection == null) {
            return null;
        }
        return (TileType)XYsubSection[z & 0xF];
    }

    @Nullable
    public TileType getTile(BlockPos pos) {
        this.scratchVector.set(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return this.getTile(this.scratchVector);
    }

    public void forEach(BiConsumer<BlockPos, TileType> consumer) {
        this.forEachTile(t -> consumer.accept(t.func_174877_v(), t));
    }

    public void forEachTile(Consumer<TileType> consumer) {
        this.internalMap.forEach((? super K vec, ? super V sectionMap) -> {
            for (TileEntity[][] tileEntities : sectionMap) {
                if (tileEntities == null) continue;
                int tileEntitiesLength = tileEntities.length;
                for (int j = 0; j < tileEntitiesLength; ++j) {
                    TileEntity[] tileEntity = tileEntities[j];
                    if (tileEntity == null) continue;
                    for (TileEntity entity : tileEntity) {
                        if (entity == null) continue;
                        consumer.accept(entity);
                    }
                }
            }
        });
    }

    public void forEachPos(Consumer<BlockPos> consumer) {
        this.forEachTile(t -> consumer.accept(t.func_174877_v()));
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    @Nullable
    public TileType getOne() {
        if (this.isEmpty()) {
            return null;
        }
        Iterator<TileEntity[][][]> iter = this.internalMap.values().iterator();
        if (!iter.hasNext()) {
            return null;
        }
        TileEntity[][][] tiles = iter.next();
        if (tiles == null) {
            return null;
        }
        for (TileEntity[][] tile2d : tiles) {
            if (tile2d == null) continue;
            for (TileEntity[] tile1d : tile2d) {
                if (tile1d == null) continue;
                for (TileEntity tileEntity : tile1d) {
                    if (tileEntity == null) continue;
                    return (TileType)tileEntity;
                }
            }
        }
        return null;
    }
}

