/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.registry;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.roguelogix.phosphophyllite.config.ConfigManager;
import net.roguelogix.phosphophyllite.registry.ContainerSupplier;
import net.roguelogix.phosphophyllite.registry.CreativeTabBlock;
import net.roguelogix.phosphophyllite.registry.IPhosphophylliteOre;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.registry.PhosphophylliteFluid;
import net.roguelogix.phosphophyllite.registry.RegisterBlock;
import net.roguelogix.phosphophyllite.registry.RegisterConfig;
import net.roguelogix.phosphophyllite.registry.RegisterContainer;
import net.roguelogix.phosphophyllite.registry.RegisterFluid;
import net.roguelogix.phosphophyllite.registry.RegisterItem;
import net.roguelogix.phosphophyllite.registry.RegisterOre;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.threading.WorkQueue;
import net.roguelogix.phosphophyllite.util.VanillaFeatureWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Registry {
    private static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/Registry");
    private static final WorkQueue preEventWorkQueue = new WorkQueue();
    private static boolean stopWorkerThread = false;
    private final WorkQueue blockRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<Block> blockRegistryEvent;
    private final WorkQueue itemRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<Item> itemRegistryEvent;
    private final Event itemGroupCreationEvent = new Event();
    private ItemGroup itemGroup = null;
    private final WorkQueue fluidRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<Fluid> fluidRegistryEvent;
    private final WorkQueue containerRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<ContainerType<?>> containerRegistryEvent;
    private final WorkQueue tileRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<TileEntityType<?>> tileRegistryEvent;
    private final Map<Class<?>, LinkedList<Block>> tileBlocks = new HashMap();
    private final WorkQueue clientSetupQueue = new WorkQueue();
    private FMLClientSetupEvent clientSetupEvent;
    private final WorkQueue commonSetupQueue = new WorkQueue();
    private FMLCommonSetupEvent commonSetupEvent;
    private final ArrayList<Runnable> biomeLoadingEventHandlers = new ArrayList();
    private BiomeLoadingEvent biomeLoadingEvent;
    private final Map<String, AnnotationHandler> annotationMap = new HashMap<String, AnnotationHandler>();

    public Registry() {
        this.annotationMap.put(RegisterBlock.class.getName(), this::registerBlockAnnotation);
        this.annotationMap.put(RegisterItem.class.getName(), this::registerItemAnnotation);
        this.annotationMap.put(RegisterFluid.class.getName(), this::registerFluidAnnotation);
        this.annotationMap.put(RegisterContainer.class.getName(), this::registerContainerAnnotation);
        this.annotationMap.put(RegisterTileEntity.class.getName(), this::registerTileEntityAnnotation);
        this.annotationMap.put(RegisterOre.class.getName(), this::registerWorldGenAnnotation);
        this.annotationMap.put(RegisterConfig.class.getName(), this::registerConfigAnnotation);
        this.annotationMap.put(OnModLoad.class.getName(), this::onModLoadAnnotation);
        String callerClass = new Exception().getStackTrace()[1].getClassName();
        String callerPackage = callerClass.substring(0, callerClass.lastIndexOf("."));
        String modNamespace = callerPackage.substring(callerPackage.lastIndexOf(".") + 1);
        ModFileScanData modFileScanData = FMLLoader.getLoadingModList().getModFileById(modNamespace).getFile().getScanResult();
        for (ModFileScanData.AnnotationData annotation : modFileScanData.getAnnotations()) {
            String className;
            AnnotationHandler handler = this.annotationMap.get(annotation.getAnnotationType().getClassName());
            if (handler == null || !(className = annotation.getClassType().getClassName()).startsWith(callerPackage)) continue;
            try {
                Class<?> clazz = Registry.class.getClassLoader().loadClass(className);
                handler.run(modNamespace, clazz, annotation.getMemberName());
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
        }
        this.itemGroupCreationEvent.trigger();
        IEventBus ModBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBus.addGenericListener(Block.class, this::blockRegistration);
        ModBus.addGenericListener(Item.class, this::itemRegistration);
        ModBus.addGenericListener(Fluid.class, this::fluidRegistration);
        ModBus.addGenericListener(ContainerType.class, this::containerRegistration);
        ModBus.addGenericListener(TileEntityType.class, this::tileEntityRegistration);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::biomeLoadingEventHandler);
        ModBus.addListener(this::commonSetupEventHandler);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ModBus.addListener(this::clientSetupEventHandler);
        }
        if (modNamespace.equals("phosphophyllite")) {
            ModBus.addListener(e -> preEventWorkQueue.enqueue(() -> {
                stopWorkerThread = true;
            }, new Event[0]));
        }
    }

    private void blockRegistration(RegistryEvent.Register<Block> event) {
        this.blockRegistryEvent = event;
        this.blockRegistrationQueue.runAll();
        this.blockRegistryEvent = null;
    }

    private void itemRegistration(RegistryEvent.Register<Item> event) {
        this.itemRegistryEvent = event;
        this.itemRegistrationQueue.runAll();
        this.itemRegistryEvent = null;
    }

    private void fluidRegistration(RegistryEvent.Register<Fluid> event) {
        this.fluidRegistryEvent = event;
        this.fluidRegistrationQueue.runAll();
        this.fluidRegistryEvent = null;
    }

    private void containerRegistration(RegistryEvent.Register<ContainerType<?>> containerTypeRegistryEvent) {
        this.containerRegistryEvent = containerTypeRegistryEvent;
        this.containerRegistrationQueue.runAll();
        this.containerRegistryEvent = null;
    }

    private void tileEntityRegistration(RegistryEvent.Register<TileEntityType<?>> tileEntityTypeRegister) {
        this.tileRegistryEvent = tileEntityTypeRegister;
        this.tileRegistrationQueue.runAll();
        this.tileRegistryEvent = null;
    }

    private void clientSetupEventHandler(FMLClientSetupEvent event) {
        this.clientSetupEvent = event;
        this.clientSetupQueue.runAll();
        this.clientSetupEvent = null;
    }

    private void commonSetupEventHandler(FMLCommonSetupEvent event) {
        this.commonSetupEvent = event;
        this.commonSetupQueue.runAll();
        this.commonSetupEvent = null;
    }

    private void biomeLoadingEventHandler(BiomeLoadingEvent event) {
        this.biomeLoadingEvent = event;
        this.biomeLoadingEventHandlers.forEach(Runnable::run);
        this.biomeLoadingEvent = null;
    }

    private void stalledWorker() {
        throw new IllegalThreadStateException("Registry worker thread stalled or dead, check logs");
    }

    private void registerBlockAnnotation(String modNamespace, Class<?> blockClazz, String memberName) {
        assert (blockClazz.isAnnotationPresent(RegisterBlock.class));
        RegisterBlock annotation = blockClazz.getAnnotation(RegisterBlock.class);
        Block[] blockArray = new Block[1];
        String modid = annotation.modid();
        if (modid.equals("")) {
            modid = modNamespace;
        }
        String name = annotation.name();
        if (modid.equals("")) {
            LOGGER.error("Unable to register block without a name");
            return;
        }
        if (!Block.class.isAssignableFrom(blockClazz)) {
            LOGGER.error("Attempt to register block from class not extended from Block. " + blockClazz.getSimpleName());
            return;
        }
        String registryName = modid + ":" + name;
        Event blockCreationEvent = preEventWorkQueue.enqueue(() -> {
            Block block;
            Constructor constructor;
            try {
                constructor = blockClazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Failed to find default constructor to create instance of " + blockClazz.getSimpleName());
                return;
            }
            constructor.setAccessible(true);
            try {
                block = (Block)constructor.newInstance(new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.error("Exception caught when instantiating instance of " + blockClazz.getSimpleName());
                e.printStackTrace();
                return;
            }
            for (Field declaredField : blockClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterBlock.Instance.class)) continue;
                if (!declaredField.getType().isAssignableFrom(blockClazz)) {
                    LOGGER.error("Unassignable instance variable " + declaredField.getName() + " in " + blockClazz.getSimpleName());
                    continue;
                }
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    LOGGER.error("Cannot set non-static instance variable " + declaredField.getName() + " in " + blockClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    declaredField.set(null, block);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (annotation.tileEntityClass() != RegisterBlock.class) {
                this.tileBlocks.computeIfAbsent(annotation.tileEntityClass(), k -> new LinkedList()).add(block);
            }
            blockArray[0] = block;
        }, new Event[0]);
        this.blockRegistrationQueue.enqueue(() -> {
            Block block;
            if (!blockCreationEvent.join(10000)) {
                this.stalledWorker();
            }
            if ((block = blockArray[0]) == null) {
                return;
            }
            block.setRegistryName(registryName);
            this.blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)block);
        }, new Event[0]);
        this.clientSetupQueue.enqueue(() -> {
            Block block;
            if (!blockCreationEvent.join(10000)) {
                this.stalledWorker();
            }
            if ((block = blockArray[0]) == null) {
                return;
            }
            RenderType renderType = null;
            for (Method declaredMethod : blockClazz.getDeclaredMethods()) {
                if (!declaredMethod.isAnnotationPresent(RegisterBlock.RenderLayer.class)) continue;
                if (Modifier.isStatic(declaredMethod.getModifiers())) {
                    LOGGER.error("Cannot call static render layer method " + declaredMethod.getName() + " in " + blockClazz.getSimpleName());
                    continue;
                }
                if (!RenderType.class.isAssignableFrom(declaredMethod.getReturnType())) {
                    LOGGER.error("RenderLayer annotated method " + declaredMethod.getName() + " in " + blockClazz.getSimpleName() + " does not return RenderType");
                    continue;
                }
                if (declaredMethod.getParameterCount() != 0) {
                    LOGGER.error("RenderLayer annotated method " + declaredMethod.getName() + " in " + blockClazz.getSimpleName() + " requires arguments");
                    continue;
                }
                if (renderType != null) {
                    LOGGER.error("Duplicate RenderLayer methods in " + blockClazz.getSimpleName());
                    continue;
                }
                declaredMethod.setAccessible(true);
                try {
                    Object obj = declaredMethod.invoke((Object)block, new Object[0]);
                    renderType = (RenderType)obj;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                    continue;
                }
                RenderTypeLookup.setRenderLayer((Block)block, (RenderType)renderType);
            }
        }, new Event[0]);
        if (annotation.registerItem()) {
            final Item[] blockItemArray = new Item[]{Blocks.field_150348_b.func_199767_j()};
            if (blockClazz.isAnnotationPresent(CreativeTabBlock.class)) {
                this.itemGroup = new ItemGroup(modNamespace){

                    @Nonnull
                    public ItemStack func_78016_d() {
                        return new ItemStack((IItemProvider)blockItemArray[0]);
                    }

                    public void func_78018_a(@Nonnull NonNullList<ItemStack> items) {
                        super.func_78018_a(items);
                        items.sort((o1, o2) -> o1.func_200301_q().getString().compareToIgnoreCase(o2.func_200301_q().getString()));
                    }
                };
                this.itemGroupCreationEvent.trigger();
            }
            this.itemRegistrationQueue.enqueue(() -> {
                Block block;
                if (!blockCreationEvent.join(10000)) {
                    this.stalledWorker();
                }
                if ((block = blockArray[0]) == null) {
                    return;
                }
                blockItemArray[0] = (Item)new BlockItem(block, new Item.Properties().func_200916_a(annotation.creativeTab() ? this.itemGroup : null)).setRegistryName(registryName);
                this.itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)blockItemArray[0]);
            }, new Event[0]);
        }
    }

    private void registerItemAnnotation(String modNamespace, Class<?> itemClazz, String memberName) {
        assert (itemClazz.isAnnotationPresent(RegisterItem.class));
        RegisterItem annotation = itemClazz.getAnnotation(RegisterItem.class);
        Item[] itemArray = new Item[1];
        String modid = annotation.modid();
        if (modid.equals("")) {
            modid = modNamespace;
        }
        String name = annotation.name();
        if (modid.equals("")) {
            LOGGER.error("Unable to register item without a name");
            return;
        }
        if (!Item.class.isAssignableFrom(itemClazz)) {
            LOGGER.error("Attempt to register item from class not extended from Item");
            return;
        }
        String registryName = modid + ":" + name;
        Event itemCreationEvent = preEventWorkQueue.enqueue(() -> {
            Item item;
            Constructor constructor;
            try {
                constructor = itemClazz.getDeclaredConstructor(Item.Properties.class);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Failed to find constructor to create instance of " + itemClazz.getSimpleName());
                return;
            }
            constructor.setAccessible(true);
            try {
                item = (Item)constructor.newInstance(new Item.Properties().func_200916_a(this.itemGroup));
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.error("Exception caught when instantiating instance of " + itemClazz.getSimpleName());
                e.printStackTrace();
                return;
            }
            for (Field declaredField : itemClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterItem.Instance.class)) continue;
                if (!declaredField.getType().isAssignableFrom(itemClazz)) {
                    LOGGER.error("Unassignable instance variable " + declaredField.getName() + " in " + itemClazz.getSimpleName());
                    continue;
                }
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    LOGGER.error("Cannot set non-static instance variable " + declaredField.getName() + " in " + itemClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    declaredField.set(null, item);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            itemArray[0] = item;
        }, this.itemGroupCreationEvent);
        this.itemRegistrationQueue.enqueue(() -> {
            Item item;
            if (!itemCreationEvent.join(10000)) {
                this.stalledWorker();
            }
            if ((item = itemArray[0]) == null) {
                return;
            }
            item.setRegistryName(registryName);
            this.itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)item);
        }, new Event[0]);
    }

    private void registerFluidAnnotation(String modNamespace, Class<?> fluidClazz, String memberName) {
        assert (fluidClazz.isAnnotationPresent(RegisterFluid.class));
        RegisterFluid annotation = fluidClazz.getAnnotation(RegisterFluid.class);
        String modid = annotation.modid().equals("") ? modNamespace : annotation.modid();
        String name = annotation.name();
        if (modid.equals("")) {
            LOGGER.error("Unable to register fluid without a name");
            return;
        }
        if (!ForgeFlowingFluid.class.isAssignableFrom(fluidClazz)) {
            LOGGER.error("Attempt to register fluid from class not extended from PhosphophylliteFluid");
            return;
        }
        String baseRegistryName = modid + ":" + name;
        PhosphophylliteFluid[] fluids = new PhosphophylliteFluid[2];
        Item[] bucketArray = new Item[1];
        FlowingFluidBlock[] blockArray = new FlowingFluidBlock[1];
        Event fluidCreationEvent = preEventWorkQueue.enqueue(() -> {
            PhosphophylliteFluid flowingInstance;
            PhosphophylliteFluid stillInstance;
            Constructor constructor;
            try {
                constructor = fluidClazz.getDeclaredConstructor(ForgeFlowingFluid.Properties.class);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Failed to find constructor to create instance of " + fluidClazz.getSimpleName());
                return;
            }
            Supplier<PhosphophylliteFluid> stillSupplier = () -> fluids[0];
            Supplier<PhosphophylliteFluid> flowingSupplier = () -> fluids[1];
            FluidAttributes.Builder attributes = FluidAttributes.builder((ResourceLocation)new ResourceLocation(modid, "fluid/" + name + "_still"), (ResourceLocation)new ResourceLocation(modid, "fluid/" + name + "_flowing"));
            attributes.color(annotation.color());
            ForgeFlowingFluid.Properties properties = new ForgeFlowingFluid.Properties(stillSupplier, flowingSupplier, attributes);
            if (annotation.registerBucket()) {
                properties.bucket(() -> bucketArray[0]);
            }
            properties.block(() -> blockArray[0]);
            try {
                stillInstance = (PhosphophylliteFluid)((Object)((Object)constructor.newInstance(properties)));
                flowingInstance = (PhosphophylliteFluid)((Object)((Object)constructor.newInstance(properties)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.error("Exception caught when instantiating instance of " + fluidClazz.getSimpleName());
                e.printStackTrace();
                return;
            }
            FlowingFluidBlock block = new FlowingFluidBlock(stillSupplier, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e());
            stillInstance.isSource = true;
            fluids[0] = stillInstance;
            fluids[1] = flowingInstance;
            blockArray[0] = block;
            for (Field declaredField : fluidClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterFluid.Instance.class)) continue;
                if (!declaredField.getType().isAssignableFrom(fluidClazz)) {
                    LOGGER.error("Unassignable instance variable " + declaredField.getName() + " in " + fluidClazz.getSimpleName());
                    continue;
                }
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    LOGGER.error("Cannot set non-static instance variable " + declaredField.getName() + " in " + fluidClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    declaredField.set(null, (Object)stillInstance);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }, new Event[0]);
        this.fluidRegistrationQueue.enqueue(() -> {
            if (!fluidCreationEvent.join(10000)) {
                this.stalledWorker();
            }
            PhosphophylliteFluid still = fluids[0];
            PhosphophylliteFluid flowing = fluids[1];
            if (still == null || flowing == null) {
                return;
            }
            still.setRegistryName(baseRegistryName);
            flowing.setRegistryName(baseRegistryName + "_flowing");
            this.fluidRegistryEvent.getRegistry().register((IForgeRegistryEntry)still);
            this.fluidRegistryEvent.getRegistry().register((IForgeRegistryEntry)flowing);
        }, new Event[0]);
        this.blockRegistrationQueue.enqueue(() -> {
            FlowingFluidBlock block;
            if (!fluidCreationEvent.join(10000)) {
                this.stalledWorker();
            }
            if ((block = blockArray[0]) == null) {
                return;
            }
            block.setRegistryName(baseRegistryName);
            this.blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)block);
        }, new Event[0]);
        if (annotation.registerBucket()) {
            this.itemRegistrationQueue.enqueue(() -> {
                if (!fluidCreationEvent.join(10000)) {
                    this.stalledWorker();
                }
                if (fluids[0] == null) {
                    return;
                }
                BucketItem bucket = new BucketItem(() -> fluids[0], new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(this.itemGroup));
                bucketArray[0] = bucket;
                bucket.setRegistryName(baseRegistryName + "_bucket");
                this.itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)bucket);
            }, new Event[0]);
        }
    }

    private void registerContainerAnnotation(String modNamespace, Class<?> containerClazz, String memberName) {
        assert (containerClazz.isAnnotationPresent(RegisterContainer.class));
        RegisterContainer annotation = containerClazz.getAnnotation(RegisterContainer.class);
        String modid = annotation.modid();
        if (modid.equals("")) {
            modid = modNamespace;
        }
        String name = annotation.name();
        if (modid.equals("")) {
            LOGGER.error("Unable to register container without a name");
            return;
        }
        if (!Container.class.isAssignableFrom(containerClazz)) {
            LOGGER.error("Attempt to register container from class not extended from Container");
            return;
        }
        String registryName = modid + ":" + name;
        ContainerType[] containerTypeArray = new ContainerType[1];
        Event containerTypeCreationEvent = preEventWorkQueue.enqueue(() -> {
            ContainerSupplier supplier = null;
            for (Field declaredField : containerClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterContainer.Supplier.class)) continue;
                int modifiers = declaredField.getModifiers();
                if (!Modifier.isStatic(modifiers)) {
                    LOGGER.error("Cannot access non-static container supplier " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    return;
                }
                if (!Modifier.isFinal(modifiers)) {
                    LOGGER.warn("Container supplier " + declaredField.getName() + " not final in" + containerClazz.getSimpleName());
                }
                if (!ContainerSupplier.class.isAssignableFrom(declaredField.getType())) {
                    LOGGER.error("Supplier annotation found on non-ContainerSupplier field " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    continue;
                }
                if (supplier != null) {
                    LOGGER.error("Duplicate suppliers for container " + containerClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    supplier = (ContainerSupplier)declaredField.get(null);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                if (supplier != null) continue;
                LOGGER.error("Container supplier field " + declaredField.getName() + " null in " + containerClazz.getSimpleName());
            }
            if (supplier == null) {
                LOGGER.error("No supplier found for container " + containerClazz.getSimpleName());
                return;
            }
            ContainerSupplier finalSupplier = supplier;
            containerTypeArray[0] = IForgeContainerType.create((windowId, playerInventory, data) -> finalSupplier.create(windowId, data.func_179259_c(), playerInventory.field_70458_d));
            for (Field declaredField : containerClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterContainer.Type.class)) continue;
                if (!declaredField.getType().isAssignableFrom(ContainerType.class)) {
                    LOGGER.error("Unassignable type variable " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    continue;
                }
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    LOGGER.error("Cannot set non-static type variable " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    declaredField.set(null, containerTypeArray[0]);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }, new Event[0]);
        this.containerRegistrationQueue.enqueue(() -> {
            ContainerType type;
            if (!containerTypeCreationEvent.join(10000)) {
                this.stalledWorker();
            }
            if ((type = containerTypeArray[0]) == null) {
                return;
            }
            type.setRegistryName(registryName);
            this.containerRegistryEvent.getRegistry().register((IForgeRegistryEntry)type);
        }, new Event[0]);
        this.clientSetupQueue.enqueue(() -> {
            ContainerType type;
            if (!containerTypeCreationEvent.join(10000)) {
                this.stalledWorker();
            }
            if ((type = containerTypeArray[0]) == null) {
                return;
            }
        }, new Event[0]);
    }

    private void registerTileEntityAnnotation(String modNamespace, Class<?> tileClazz, String memberName) {
        assert (tileClazz.isAnnotationPresent(RegisterTileEntity.class));
        RegisterTileEntity annotation = tileClazz.getAnnotation(RegisterTileEntity.class);
        String modid = annotation.modid();
        if (modid.equals("")) {
            modid = modNamespace;
        }
        String name = annotation.name();
        if (modid.equals("")) {
            LOGGER.error("Unable to register tile type without a name");
            return;
        }
        if (!TileEntity.class.isAssignableFrom(tileClazz)) {
            LOGGER.error("Attempt to register tile type from class not extended from TileEntity");
            return;
        }
        String registryName = modid + ":" + name;
        TileSupplier[] supplier = new TileSupplier[1];
        Event supplierLookupEvent = preEventWorkQueue.enqueue(() -> {
            for (Field declaredField : tileClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterTileEntity.Supplier.class)) continue;
                int modifiers = declaredField.getModifiers();
                if (!Modifier.isStatic(modifiers)) {
                    LOGGER.error("Cannot access non-static tile supplier " + declaredField.getName() + " in " + tileClazz.getSimpleName());
                    return;
                }
                if (!Modifier.isFinal(modifiers)) {
                    LOGGER.warn("Tile supplier " + declaredField.getName() + " not final in" + tileClazz.getSimpleName());
                }
                if (!TileSupplier.class.isAssignableFrom(declaredField.getType())) {
                    LOGGER.error("Supplier annotation found on non-TileSupplier field " + declaredField.getName() + " in " + tileClazz.getSimpleName());
                    continue;
                }
                if (supplier[0] != null) {
                    LOGGER.error("Duplicate suppliers for tile " + tileClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    supplier[0] = (TileSupplier)declaredField.get(null);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                if (supplier[0] != null) continue;
                LOGGER.error("Tile supplier field " + declaredField.getName() + " null in " + tileClazz.getSimpleName());
            }
            if (supplier[0] == null) {
                LOGGER.error("No supplier found for tile " + tileClazz.getSimpleName());
            }
        }, new Event[0]);
        this.tileRegistrationQueue.enqueue(() -> {
            if (!supplierLookupEvent.join(10000)) {
                this.stalledWorker();
            }
            if (supplier[0] == null) {
                return;
            }
            LinkedList<Block> blocks = this.tileBlocks.remove(tileClazz);
            if (blocks == null) {
                return;
            }
            TileEntityType type = TileEntityType.Builder.func_223042_a((Supplier)supplier[0], (Block[])blocks.toArray(new Block[blocks.size()])).func_206865_a(null);
            type.setRegistryName(registryName);
            boolean typeSet = false;
            for (Field declaredField : tileClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterTileEntity.Type.class)) continue;
                if (!declaredField.getType().isAssignableFrom(TileEntityType.class)) {
                    LOGGER.error("Unassignable type variable " + declaredField.getName() + " in " + tileClazz.getSimpleName());
                    continue;
                }
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    LOGGER.error("Cannot set non-static type variable " + declaredField.getName() + " in " + tileClazz.getSimpleName());
                    continue;
                }
                if (typeSet) {
                    LOGGER.warn("Duplicate TileEntityType fields in " + tileClazz.getSimpleName());
                }
                declaredField.setAccessible(true);
                try {
                    declaredField.set(null, type);
                    typeSet = true;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (!typeSet) {
                throw new IllegalStateException("Tile entity type unable to be saved for " + tileClazz.getSimpleName());
            }
            this.tileRegistryEvent.getRegistry().register((IForgeRegistryEntry)type);
        }, new Event[0]);
    }

    private void registerWorldGenAnnotation(String modNamespace, Class<?> oreClazz, String memberName) {
        assert (oreClazz.isAnnotationPresent(RegisterOre.class));
        if (!oreClazz.isAnnotationPresent(RegisterBlock.class)) {
            LOGGER.error("Cannot register unknown block for world generation");
            return;
        }
        RegisterBlock blockAnnotation = oreClazz.getAnnotation(RegisterBlock.class);
        String modid = blockAnnotation.modid();
        if (modid.equals("")) {
            modid = modNamespace;
        }
        String name = blockAnnotation.name();
        String registryName = modid + ":" + name;
        ResourceLocation resourceLocation = new ResourceLocation(registryName);
        VanillaFeatureWrapper[] wrapperArray = new VanillaFeatureWrapper[1];
        Block[] oreInstanceArray = new Block[1];
        HashSet spawnBiomes = new HashSet();
        this.commonSetupQueue.enqueue(() -> {
            VanillaFeatureWrapper wrapper;
            Block oreInstance = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            if (!(oreInstance instanceof IPhosphophylliteOre)) {
                LOGGER.error("Attempt to register non-IPhosphophylliteOre block for world generation");
                return;
            }
            IPhosphophylliteOre oreInfo = (IPhosphophylliteOre)oreInstance;
            RuleTest fillerBlock = oreInfo.isNetherOre() ? OreFeatureConfig.FillerBlockType.field_241884_c : OreFeatureConfig.FillerBlockType.field_241882_a;
            ConfiguredFeature feature = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(fillerBlock, oreInstance.func_176223_P(), oreInfo.size())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(oreInfo.minLevel(), 0, oreInfo.maxLevel()))).func_242728_a()).func_242731_b(oreInfo.count());
            boolean doSpawn = oreInfo.doSpawn();
            wrapperArray[0] = wrapper = new VanillaFeatureWrapper(feature, () -> doSpawn);
            oreInstanceArray[0] = oreInstance;
            spawnBiomes.addAll(Arrays.asList(oreInfo.spawnBiomes()));
            this.commonSetupEvent.enqueueWork(() -> (VanillaFeatureWrapper)((Object)((Object)((Object)net.minecraft.util.registry.Registry.func_218322_a((net.minecraft.util.registry.Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)resourceLocation, (Object)((Object)wrapper))))));
        }, new Event[0]);
        this.biomeLoadingEventHandlers.add(() -> {
            IPhosphophylliteOre oreInfo = (IPhosphophylliteOre)oreInstanceArray[0];
            if (this.biomeLoadingEvent.getCategory() == Biome.Category.NETHER != oreInfo.isNetherOre()) {
                return;
            }
            if (spawnBiomes.size() > 0 && !spawnBiomes.contains(this.biomeLoadingEvent.getName().toString())) {
                return;
            }
            this.biomeLoadingEvent.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> wrapperArray[0]);
        });
    }

    private void registerConfigAnnotation(String modNamespace, Class<?> configClazz, String memberName) {
        ConfigManager.registerConfig(configClazz, modNamespace);
    }

    private void onModLoadAnnotation(String modNamespace, Class<?> modLoadClazz, String memberName) {
        try {
            Method method = modLoadClazz.getDeclaredMethod(memberName.substring(0, memberName.indexOf(40)), new Class[0]);
            if (!Modifier.isStatic(method.getModifiers())) {
                LOGGER.error("Cannot call non-static @OnModLoad method " + method.getName() + " in " + modLoadClazz.getSimpleName());
                return;
            }
            if (method.getParameterCount() != 0) {
                LOGGER.error("Cannot call @OnModLoad method with parameters " + method.getName() + " in " + modLoadClazz.getSimpleName());
                return;
            }
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        Thread thread = new Thread(() -> {
            LOGGER.info("Thread started");
            while (!stopWorkerThread) {
                try {
                    preEventWorkQueue.runAll();
                }
                catch (Throwable e) {
                    LOGGER.error("Exception rolled back");
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            LOGGER.info("Thread stopped");
        });
        thread.setName("Phosphophyllite Registry Worker");
        thread.setDaemon(true);
        thread.start();
    }

    private static interface AnnotationHandler {
        public void run(String var1, Class<?> var2, String var3);
    }
}

