/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.rectangular;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockBlock;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.generic.ValidationError;
import net.roguelogix.phosphophyllite.multiblock.generic.Validator;
import net.roguelogix.phosphophyllite.multiblock.rectangular.InvalidBlock;
import net.roguelogix.phosphophyllite.multiblock.rectangular.RectangularMultiblockBlock;
import net.roguelogix.phosphophyllite.multiblock.rectangular.RectangularMultiblockTile;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.util.Util;

public class RectangularMultiblockController<ControllerType extends RectangularMultiblockController<ControllerType, TileType, BlockType>, TileType extends RectangularMultiblockTile<ControllerType, TileType, BlockType>, BlockType extends RectangularMultiblockBlock<ControllerType, TileType, BlockType>>
extends MultiblockController<ControllerType, TileType, BlockType> {
    protected boolean orientationAgnostic = true;
    protected boolean xzAgnostic = true;
    protected final Vector3i minSize = new Vector3i();
    protected final Vector3i maxSize = new Vector3i();
    protected Validator<Block> cornerValidator = null;
    protected Validator<Block> frameValidator = null;
    protected Validator<Block> exteriorValidator = null;
    protected Validator<Block> interiorValidator = null;
    protected Validator<Block> genericValidator = null;
    private final Validator<ControllerType> mainValidator = controller -> {
        int minX = controller.minCoord().x();
        int minY = controller.minCoord().y();
        int minZ = controller.minCoord().z();
        int maxX = controller.maxCoord().x();
        int maxY = controller.maxCoord().y();
        int maxZ = controller.maxCoord().z();
        Vector3i[] allowedOrientations = new Vector3i[controller.orientationAgnostic ? 6 : (controller.xzAgnostic ? 2 : 1)];
        if (controller.orientationAgnostic) {
            allowedOrientations[0] = new Vector3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
            allowedOrientations[1] = new Vector3i(maxX - minX + 1, maxZ - minZ + 1, maxY - minY + 1);
            allowedOrientations[2] = new Vector3i(maxY - minY + 1, maxX - minX + 1, maxZ - minZ + 1);
            allowedOrientations[3] = new Vector3i(maxY - minY + 1, maxZ - minZ + 1, maxX - minX + 1);
            allowedOrientations[4] = new Vector3i(maxZ - minZ + 1, maxX - minX + 1, maxY - minY + 1);
            allowedOrientations[5] = new Vector3i(maxZ - minZ + 1, maxY - minY + 1, maxX - minX + 1);
        } else if (controller.xzAgnostic) {
            allowedOrientations[0] = new Vector3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
            allowedOrientations[1] = new Vector3i(maxZ - minZ + 1, maxY - minY + 1, maxX - minX + 1);
        } else {
            allowedOrientations[0] = new Vector3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
        }
        Vector3i dimensions = null;
        for (Vector3i allowedOrientation : allowedOrientations) {
            if ((controller.minSize.x | controller.minSize.y | controller.minSize.z) >= 0 && (allowedOrientation.x < controller.minSize.x || allowedOrientation.y < controller.minSize.y || allowedOrientation.z < controller.minSize.z) || (controller.maxSize.x | controller.maxSize.y | controller.maxSize.z) >= 0 && (allowedOrientation.x > controller.maxSize.x || allowedOrientation.y > controller.maxSize.y || allowedOrientation.z > controller.maxSize.z)) continue;
            dimensions = allowedOrientation;
            break;
        }
        if (dimensions == null) {
            throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.phosphophyllite.dimensions", new Object[]{allowedOrientations[0].x, allowedOrientations[0].y, allowedOrientations[0].z, controller.minSize.x, controller.minSize.y, controller.minSize.z, controller.maxSize.x, controller.maxSize.y, controller.maxSize.z}));
        }
        Util.chunkCachedBlockStateIteration(controller.minCoord(), controller.maxCoord(), controller.world, (blockState, pos) -> {
            Block block = blockState.func_177230_c();
            int extremes = 0;
            if (pos.x == minX || pos.x == maxX) {
                ++extremes;
            }
            if (pos.y == minY || pos.y == maxY) {
                ++extremes;
            }
            if (pos.z == minZ || pos.z == maxZ) {
                ++extremes;
            }
            switch (extremes) {
                case 3: {
                    if (block instanceof RectangularMultiblockBlock && this.blockTypeValidator.validate((RectangularMultiblockBlock)block)) {
                        if (((RectangularMultiblockBlock)block).isGoodForCorner()) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "corner");
                    }
                    if (controller.cornerValidator != null) {
                        if (controller.cornerValidator.validate(block)) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "corner");
                    }
                }
                case 2: {
                    if (block instanceof RectangularMultiblockBlock && this.blockTypeValidator.validate((RectangularMultiblockBlock)block)) {
                        if (((RectangularMultiblockBlock)block).isGoodForFrame()) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "frame");
                    }
                    if (controller.frameValidator != null) {
                        if (controller.frameValidator.validate(block)) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "frame");
                    }
                }
                case 1: {
                    if (block instanceof RectangularMultiblockBlock && this.blockTypeValidator.validate((RectangularMultiblockBlock)block)) {
                        if (((RectangularMultiblockBlock)block).isGoodForExterior()) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "exterior");
                    }
                    if (controller.exteriorValidator != null) {
                        if (controller.exteriorValidator.validate(block)) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "exterior");
                    }
                }
                default: {
                    if (extremes == 0) {
                        if (block instanceof RectangularMultiblockBlock && this.blockTypeValidator.validate((RectangularMultiblockBlock)block)) {
                            if (((RectangularMultiblockBlock)block).isGoodForInterior()) break;
                            throw new InvalidBlock(block, (Vector3i)pos, "interior");
                        }
                        if (controller.interiorValidator != null) {
                            if (controller.interiorValidator.validate(block)) break;
                            throw new InvalidBlock(block, (Vector3i)pos, "interior");
                        }
                    }
                    if (controller.genericValidator != null) {
                        if (controller.genericValidator.validate(block)) break;
                        throw new InvalidBlock(block, (Vector3i)pos, "generic");
                    }
                    throw new InvalidBlock(block, (Vector3i)pos, "generic");
                }
            }
        });
        return true;
    };

    public RectangularMultiblockController(@Nonnull World world, @Nonnull Validator<MultiblockTile<?, ?, ?>> tileTypeValidator, @Nonnull Validator<MultiblockBlock<?, ?, ?>> blockTypeValidator) {
        super(world, tileTypeValidator, blockTypeValidator);
        this.setAssemblyValidator(null);
    }

    @Override
    protected final void setAssemblyValidator(@Nullable Validator<ControllerType> validator) {
        if (validator == null) {
            super.setAssemblyValidator(this.mainValidator);
            return;
        }
        super.setAssemblyValidator(Validator.and(this.mainValidator, validator));
    }
}

