/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.generic;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.items.DebugTool;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockBlock;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockController;

public abstract class MultiblockTile<ControllerType extends MultiblockController<ControllerType, TileType, BlockType>, TileType extends MultiblockTile<ControllerType, TileType, BlockType>, BlockType extends MultiblockBlock<ControllerType, TileType, BlockType>>
extends TileEntity {
    protected ControllerType controller;
    long lastSavedTick = 0L;
    private boolean attemptAttach = true;
    private boolean allowAttach = true;
    boolean isSaveDelegate = false;
    boolean preExistingBlock = false;
    CompoundNBT controllerData = null;

    public TileType self() {
        return (TileType)((Object)this);
    }

    public void attemptAttach() {
        this.controller = null;
        this.attemptAttach = true;
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            Phosphophyllite.attachTile(this);
        }
    }

    public MultiblockTile(@Nonnull TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void attachToNeighbors() {
        assert (this.field_145850_b != null);
        if (this.allowAttach && this.attemptAttach && !this.field_145850_b.field_72995_K) {
            this.attemptAttach = false;
            Block thisBlock = this.func_195044_w().func_177230_c();
            if (!(thisBlock instanceof MultiblockBlock)) {
                return;
            }
            if (((MultiblockBlock)thisBlock).usesAssemblyState()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)MultiblockBlock.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
            }
            if (this.controller != null) {
                ((MultiblockController)this.controller).detach(this.self());
                this.controller = null;
            }
            BlockPos.Mutable possibleTilePos = new BlockPos.Mutable();
            for (Direction value : Direction.values()) {
                TileEntity possibleTile;
                possibleTilePos.func_189533_g((Vector3i)this.field_174879_c);
                possibleTilePos.func_189536_c(value);
                IChunk chunk = this.field_145850_b.func_217353_a(possibleTilePos.func_177958_n() >> 4, possibleTilePos.func_177952_p() >> 4, ChunkStatus.field_222617_m, false);
                if (chunk == null || !((possibleTile = chunk.func_175625_s((BlockPos)possibleTilePos)) instanceof MultiblockTile)) continue;
                if (((MultiblockTile)possibleTile).controller != null) {
                    ((MultiblockController)((MultiblockTile)possibleTile).controller).attemptAttach(this);
                    continue;
                }
                ((MultiblockTile)possibleTile).attemptAttach = true;
            }
            if (this.controller == null) {
                ((MultiblockController)this.createController()).attemptAttach((MultiblockTile<?, ?, ?>)((Object)this.self()));
            }
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.attemptAttach();
        if (this.field_145850_b.field_72995_K) {
            this.controllerData = null;
        }
    }

    public void onLoad() {
        this.attemptAttach();
    }

    public final void func_145843_s() {
        if (this.controller != null) {
            ((MultiblockController)this.controller).detach(this.self());
        }
        this.allowAttach = false;
        this.onRemoved(false);
        super.func_145843_s();
    }

    public final void onChunkUnloaded() {
        if (this.controller != null) {
            ((MultiblockController)this.controller).detach(this.self(), true);
        }
        this.allowAttach = false;
        this.onRemoved(true);
        super.onChunkUnloaded();
    }

    public void onRemoved(boolean chunkUnload) {
    }

    @Nonnull
    public abstract ControllerType createController();

    protected void readNBT(@Nonnull CompoundNBT compound) {
    }

    @Nonnull
    protected CompoundNBT writeNBT() {
        return new CompoundNBT();
    }

    public final void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("controllerData")) {
            this.controllerData = compound.func_74775_l("controllerData");
        }
        if (compound.func_74764_b("userdata")) {
            this.readNBT(compound.func_74775_l("userdata"));
        }
        this.isSaveDelegate = compound.func_74767_n("isSaveDelegate");
        this.preExistingBlock = true;
    }

    @Nonnull
    public final CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.isSaveDelegate && this.controller != null && ((MultiblockController)this.controller).blocks.containsTile(this.self())) {
            compound.func_218657_a("controllerData", (INBT)((MultiblockController)this.controller).getNBT());
        }
        compound.func_218657_a("userdata", (INBT)this.writeNBT());
        compound.func_74757_a("isSaveDelegate", this.isSaveDelegate);
        return compound;
    }

    protected String getDebugInfo() {
        return ((MultiblockController)this.controller).getDebugInfo();
    }

    @Nonnull
    public ActionResultType onBlockActivated(@Nonnull PlayerEntity player, @Nonnull Hand handIn) {
        if (handIn == Hand.MAIN_HAND) {
            if (!(player.func_184614_ca() != ItemStack.field_190927_a || ((MultiblockBlock)this.func_195044_w().func_177230_c()).usesAssemblyState() && ((Boolean)this.func_195044_w().func_177229_b((Property)MultiblockBlock.ASSEMBLED)).booleanValue())) {
                if (this.controller != null && ((MultiblockController)this.controller).assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
                    if (((MultiblockController)this.controller).lastValidationError != null) {
                        player.func_145747_a(((MultiblockController)this.controller).lastValidationError.getTextComponent(), Util.field_240973_b_);
                    } else {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("multiblock.error.phosphophyllite.unknown"), Util.field_240973_b_);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (player.func_184614_ca().func_77973_b() == DebugTool.INSTANCE) {
                if (this.controller != null) {
                    player.func_145747_a((ITextComponent)new StringTextComponent(this.getDebugInfo()), Util.field_240973_b_);
                } else if (!this.field_145850_b.field_72995_K) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("null controller on server"), Util.field_240973_b_);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    protected BlockState assembledBlockState() {
        BlockState state = this.func_195044_w();
        if (((MultiblockBlock)state.func_177230_c()).usesAssemblyState()) {
            state = (BlockState)state.func_206870_a((Property)MultiblockBlock.ASSEMBLED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected BlockState disassembledBlockState() {
        BlockState state = this.func_195044_w();
        if (((MultiblockBlock)state.func_177230_c()).usesAssemblyState()) {
            state = (BlockState)state.func_206870_a((Property)MultiblockBlock.ASSEMBLED, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }
}

